﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2, TSource3, TSource4> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth)
		{
			this.First = first;
			this.Second = second;
			this.Third = third;
			this.Fourth = fourth;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		internal IObservable<TSource3> Third { get; }

		internal IObservable<TSource4> Fourth { get; }

		public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5> And<TSource5>(IObservable<TSource5> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5>(this.First, this.Second, this.Third, this.Fourth, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TSource3, TSource4, TResult>(this, selector);
		}
	}
}
