﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2, TSource3> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third)
		{
			this.First = first;
			this.Second = second;
			this.Third = third;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		internal IObservable<TSource3> Third { get; }

		public Pattern<TSource1, TSource2, TSource3, TSource4> And<TSource4>(IObservable<TSource4> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3, TSource4>(this.First, this.Second, this.Third, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TSource3, TResult>(this, selector);
		}
	}
}
