﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second)
		{
			this.First = first;
			this.Second = second;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		public Pattern<TSource1, TSource2, TSource3> And<TSource3>(IObservable<TSource3> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3>(this.First, this.Second, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TResult>(this, selector);
		}
	}
}
