﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1> : Pattern
	{
		internal Pattern(IObservable<TSource1> first)
		{
			this.First = first;
		}

		internal IObservable<TSource1> First { get; }

		public Plan<TResult> Then<TResult>(Func<TSource1, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TResult>(this, selector);
		}
	}
}
