﻿using System;

namespace System.Reactive.Joins
{
	public class Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y> : Pattern
	{
		internal Pattern(IObservable<TSource1> first, IObservable<TSource2> second, IObservable<TSource3> third, IObservable<TSource4> fourth, IObservable<TSource5> fifth, IObservable<TSource6> sixth, IObservable<TSource7> seventh, IObservable<TSource8> eighth, IObservable<TSource9> ninth, IObservable<T> tenth, IObservable<U> eleventh, IObservable<V> twelfth, IObservable<W> thirteenth, IObservable<X> fourteenth, IObservable<Y> fifteenth)
		{
			this.First = first;
			this.Second = second;
			this.Third = third;
			this.Fourth = fourth;
			this.Fifth = fifth;
			this.Sixth = sixth;
			this.Seventh = seventh;
			this.Eighth = eighth;
			this.Ninth = ninth;
			this.Tenth = tenth;
			this.Eleventh = eleventh;
			this.Twelfth = twelfth;
			this.Thirteenth = thirteenth;
			this.Fourteenth = fourteenth;
			this.Fifteenth = fifteenth;
		}

		internal IObservable<TSource1> First { get; }

		internal IObservable<TSource2> Second { get; }

		internal IObservable<TSource3> Third { get; }

		internal IObservable<TSource4> Fourth { get; }

		internal IObservable<TSource5> Fifth { get; }

		internal IObservable<TSource6> Sixth { get; }

		internal IObservable<TSource7> Seventh { get; }

		internal IObservable<TSource8> Eighth { get; }

		internal IObservable<TSource9> Ninth { get; }

		internal IObservable<T> Tenth { get; }

		internal IObservable<U> Eleventh { get; }

		internal IObservable<V> Twelfth { get; }

		internal IObservable<W> Thirteenth { get; }

		internal IObservable<X> Fourteenth { get; }

		internal IObservable<Y> Fifteenth { get; }

		public Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z> And<Z>(IObservable<Z> other)
		{
			if (other == null)
			{
				throw new ArgumentNullException("other");
			}
			return new Pattern<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, Z>(this.First, this.Second, this.Third, this.Fourth, this.Fifth, this.Sixth, this.Seventh, this.Eighth, this.Ninth, this.Tenth, this.Eleventh, this.Twelfth, this.Thirteenth, this.Fourteenth, this.Fifteenth, other);
		}

		public Plan<TResult> Then<TResult>(Func<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult> selector)
		{
			if (selector == null)
			{
				throw new ArgumentNullException("selector");
			}
			return new Plan<TSource1, TSource2, TSource3, TSource4, TSource5, TSource6, TSource7, TSource8, TSource9, T, U, V, W, X, Y, TResult>(this, selector);
		}
	}
}
