﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Joins
{
	internal abstract class ActivePlan
	{
		internal abstract void Match();

		protected ActivePlan(Action onCompleted)
		{
			this._onCompleted = onCompleted;
		}

		protected void AddJoinObserver(IJoinObserver joinObserver)
		{
			if (!this._joinObservers.ContainsKey(joinObserver))
			{
				this._joinObservers.Add(joinObserver, joinObserver);
			}
		}

		protected void Dequeue()
		{
			foreach (IJoinObserver joinObserver in this._joinObservers.Values)
			{
				joinObserver.Dequeue();
			}
		}

		private readonly Dictionary<IJoinObserver, IJoinObserver> _joinObservers = new Dictionary<IJoinObserver, IJoinObserver>();

		protected readonly Action _onCompleted;
	}
}
