﻿using System;

namespace System.Reactive.Joins
{
	internal class ActivePlan<T1, T2, T3, T4, T5, T6, T7, T8> : ActivePlan
	{
		internal ActivePlan(JoinObserver<T1> first, JoinObserver<T2> second, JoinObserver<T3> third, JoinObserver<T4> fourth, JoinObserver<T5> fifth, JoinObserver<T6> sixth, JoinObserver<T7> seventh, JoinObserver<T8> eighth, Action<T1, T2, T3, T4, T5, T6, T7, T8> onNext, Action onCompleted)
			: base(onCompleted)
		{
			this._onNext = onNext;
			this._first = first;
			this._second = second;
			this._third = third;
			this._fourth = fourth;
			this._fifth = fifth;
			this._sixth = sixth;
			this._seventh = seventh;
			this._eighth = eighth;
			base.AddJoinObserver(first);
			base.AddJoinObserver(second);
			base.AddJoinObserver(third);
			base.AddJoinObserver(fourth);
			base.AddJoinObserver(fifth);
			base.AddJoinObserver(sixth);
			base.AddJoinObserver(seventh);
			base.AddJoinObserver(eighth);
		}

		internal override void Match()
		{
			if (this._first.Queue.Count > 0 && this._second.Queue.Count > 0 && this._third.Queue.Count > 0 && this._fourth.Queue.Count > 0 && this._fifth.Queue.Count > 0 && this._sixth.Queue.Count > 0 && this._seventh.Queue.Count > 0 && this._eighth.Queue.Count > 0)
			{
				Notification<T1> notification = this._first.Queue.Peek();
				Notification<T2> notification2 = this._second.Queue.Peek();
				Notification<T3> notification3 = this._third.Queue.Peek();
				Notification<T4> notification4 = this._fourth.Queue.Peek();
				Notification<T5> notification5 = this._fifth.Queue.Peek();
				Notification<T6> notification6 = this._sixth.Queue.Peek();
				Notification<T7> notification7 = this._seventh.Queue.Peek();
				Notification<T8> notification8 = this._eighth.Queue.Peek();
				if (notification.Kind != NotificationKind.OnCompleted && notification2.Kind != NotificationKind.OnCompleted && notification3.Kind != NotificationKind.OnCompleted && notification4.Kind != NotificationKind.OnCompleted && notification5.Kind != NotificationKind.OnCompleted && notification6.Kind != NotificationKind.OnCompleted && notification7.Kind != NotificationKind.OnCompleted)
				{
					if (notification8.Kind != NotificationKind.OnCompleted)
					{
						base.Dequeue();
						this._onNext(notification.Value, notification2.Value, notification3.Value, notification4.Value, notification5.Value, notification6.Value, notification7.Value, notification8.Value);
						return;
					}
				}
				this._onCompleted();
				return;
			}
		}

		private readonly Action<T1, T2, T3, T4, T5, T6, T7, T8> _onNext;

		private readonly JoinObserver<T1> _first;

		private readonly JoinObserver<T2> _second;

		private readonly JoinObserver<T3> _third;

		private readonly JoinObserver<T4> _fourth;

		private readonly JoinObserver<T5> _fifth;

		private readonly JoinObserver<T6> _sixth;

		private readonly JoinObserver<T7> _seventh;

		private readonly JoinObserver<T8> _eighth;
	}
}
