﻿using System;

namespace System.Reactive.Joins
{
	internal class ActivePlan<T1, T2, T3, T4> : ActivePlan
	{
		internal ActivePlan(JoinObserver<T1> first, JoinObserver<T2> second, JoinObserver<T3> third, JoinObserver<T4> fourth, Action<T1, T2, T3, T4> onNext, Action onCompleted)
			: base(onCompleted)
		{
			this._onNext = onNext;
			this._first = first;
			this._second = second;
			this._third = third;
			this._fourth = fourth;
			base.AddJoinObserver(first);
			base.AddJoinObserver(second);
			base.AddJoinObserver(third);
			base.AddJoinObserver(fourth);
		}

		internal override void Match()
		{
			if (this._first.Queue.Count > 0 && this._second.Queue.Count > 0 && this._third.Queue.Count > 0 && this._fourth.Queue.Count > 0)
			{
				Notification<T1> notification = this._first.Queue.Peek();
				Notification<T2> notification2 = this._second.Queue.Peek();
				Notification<T3> notification3 = this._third.Queue.Peek();
				Notification<T4> notification4 = this._fourth.Queue.Peek();
				if (notification.Kind != NotificationKind.OnCompleted && notification2.Kind != NotificationKind.OnCompleted && notification3.Kind != NotificationKind.OnCompleted)
				{
					if (notification4.Kind != NotificationKind.OnCompleted)
					{
						base.Dequeue();
						this._onNext(notification.Value, notification2.Value, notification3.Value, notification4.Value);
						return;
					}
				}
				this._onCompleted();
				return;
			}
		}

		private readonly Action<T1, T2, T3, T4> _onNext;

		private readonly JoinObserver<T1> _first;

		private readonly JoinObserver<T2> _second;

		private readonly JoinObserver<T3> _third;

		private readonly JoinObserver<T4> _fourth;
	}
}
