﻿using System;

namespace System.Reactive.Joins
{
	internal class ActivePlan<T1, T2> : ActivePlan
	{
		internal ActivePlan(JoinObserver<T1> first, JoinObserver<T2> second, Action<T1, T2> onNext, Action onCompleted)
			: base(onCompleted)
		{
			this._onNext = onNext;
			this._first = first;
			this._second = second;
			base.AddJoinObserver(first);
			base.AddJoinObserver(second);
		}

		internal override void Match()
		{
			if (this._first.Queue.Count > 0 && this._second.Queue.Count > 0)
			{
				Notification<T1> notification = this._first.Queue.Peek();
				Notification<T2> notification2 = this._second.Queue.Peek();
				if (notification.Kind != NotificationKind.OnCompleted)
				{
					if (notification2.Kind != NotificationKind.OnCompleted)
					{
						base.Dequeue();
						this._onNext(notification.Value, notification2.Value);
						return;
					}
				}
				this._onCompleted();
				return;
			}
		}

		private readonly Action<T1, T2> _onNext;

		private readonly JoinObserver<T1> _first;

		private readonly JoinObserver<T2> _second;
	}
}
