﻿using System;

namespace System.Reactive.Joins
{
	internal class ActivePlan<T1> : ActivePlan
	{
		internal ActivePlan(JoinObserver<T1> first, Action<T1> onNext, Action onCompleted)
			: base(onCompleted)
		{
			this._onNext = onNext;
			this._first = first;
			base.AddJoinObserver(first);
		}

		internal override void Match()
		{
			if (this._first.Queue.Count > 0)
			{
				Notification<T1> notification = this._first.Queue.Peek();
				if (notification.Kind == NotificationKind.OnCompleted)
				{
					this._onCompleted();
					return;
				}
				base.Dequeue();
				this._onNext(notification.Value);
			}
		}

		private readonly Action<T1> _onNext;

		private readonly JoinObserver<T1> _first;
	}
}
