﻿using System;

namespace System.Reactive
{
	internal sealed class ImmutableList<T>
	{
		private ImmutableList()
		{
			this._data = Array.Empty<T>();
		}

		public ImmutableList(T[] data)
		{
			this._data = data;
		}

		public T[] Data
		{
			get
			{
				return this._data;
			}
		}

		public ImmutableList<T> Add(T value)
		{
			T[] array = new T[this._data.Length + 1];
			Array.Copy(this._data, array, this._data.Length);
			array[this._data.Length] = value;
			return new ImmutableList<T>(array);
		}

		public ImmutableList<T> Remove(T value)
		{
			int num = this.IndexOf(value);
			if (num < 0)
			{
				return this;
			}
			int num2 = this._data.Length;
			if (num2 == 1)
			{
				return ImmutableList<T>.Empty;
			}
			T[] array = new T[num2 - 1];
			Array.Copy(this._data, 0, array, 0, num);
			Array.Copy(this._data, num + 1, array, num, num2 - num - 1);
			return new ImmutableList<T>(array);
		}

		private int IndexOf(T value)
		{
			for (int i = 0; i < this._data.Length; i++)
			{
				if (object.Equals(this._data[i], value))
				{
					return i;
				}
			}
			return -1;
		}

		public static readonly ImmutableList<T> Empty = new ImmutableList<T>();

		private readonly T[] _data;
	}
}
