﻿using System;
using System.Collections.Generic;

namespace System.Reactive
{
	internal static class Helpers
	{
		public static int? GetLength<T>(IEnumerable<T> source)
		{
			T[] array = source as T[];
			if (array != null)
			{
				return new int?(array.Length);
			}
			IList<T> list = source as IList<T>;
			if (list != null)
			{
				return new int?(list.Count);
			}
			return null;
		}

		public static IObservable<T> Unpack<T>(IObservable<T> source)
		{
			bool flag;
			do
			{
				flag = false;
				IEvaluatableObservable<T> evaluatableObservable = source as IEvaluatableObservable<T>;
				if (evaluatableObservable != null)
				{
					source = evaluatableObservable.Eval();
					flag = true;
				}
			}
			while (flag);
			return source;
		}

		public static bool All(this bool[] values)
		{
			for (int i = 0; i < values.Length; i++)
			{
				if (!values[i])
				{
					return false;
				}
			}
			return true;
		}

		public static bool AllExcept(this bool[] values, int index)
		{
			for (int i = 0; i < values.Length; i++)
			{
				if (i != index && !values[i])
				{
					return false;
				}
			}
			return true;
		}
	}
}
