﻿using System;
using System.Reactive.PlatformServices;

namespace System.Reactive
{
	internal static class ExceptionHelpers
	{
		public static void Throw(this Exception exception)
		{
			ExceptionHelpers.Services.Value.Rethrow(exception);
		}

		public static void ThrowIfNotNull(this Exception exception)
		{
			if (exception != null)
			{
				ExceptionHelpers.Services.Value.Rethrow(exception);
			}
		}

		private static GInterface6 Initialize()
		{
			return PlatformEnlightenmentProvider.Current.GetService<GInterface6>(Array.Empty<object>()) ?? new DefaultExceptionServices();
		}

		private static readonly Lazy<GInterface6> Services = new Lazy<GInterface6>(new Func<GInterface6>(ExceptionHelpers.Initialize));
	}
}
