﻿using System;

namespace System.Reactive
{
	internal sealed class EventPatternSource<T> : EventPatternSourceBase<object, T>, GInterface3<T>
	{
		public EventPatternSource(IObservable<EventPattern<object, T>> source, Action<Action<object, T>, EventPattern<object, T>> invokeHandler)
			: base(source, invokeHandler)
		{
		}

		event EventHandler<T> GInterface3<T>.OnNext
		{
			add
			{
				base.Add(value, delegate(object o, T e)
				{
					value(o, e);
				});
			}
			remove
			{
				base.Remove(value);
			}
		}
	}
}
