﻿using System;
using System.Collections.Generic;

namespace System.Reactive
{
	public class EventPattern<TSender, T> : IEquatable<EventPattern<TSender, T>>, IEventPattern<TSender, T>
	{
		public EventPattern(TSender sender, T e)
		{
			this.Sender = sender;
			this.EventArgs = e;
		}

		public TSender Sender { get; }

		public T EventArgs { get; }

		public bool Equals(EventPattern<TSender, T> other)
		{
			return other != null && (this == other || (EqualityComparer<TSender>.Default.Equals(this.Sender, other.Sender) && EqualityComparer<T>.Default.Equals(this.EventArgs, other.EventArgs)));
		}

		public override bool Equals(object obj)
		{
			return this.Equals(obj as EventPattern<TSender, T>);
		}

		public override int GetHashCode()
		{
			int hashCode = EqualityComparer<TSender>.Default.GetHashCode(this.Sender);
			int hashCode2 = EqualityComparer<T>.Default.GetHashCode(this.EventArgs);
			return (hashCode << 5) + (hashCode ^ hashCode2);
		}

		public static bool operator ==(EventPattern<TSender, T> first, EventPattern<TSender, T> second)
		{
			return object.Equals(first, second);
		}

		public static bool operator !=(EventPattern<TSender, T> first, EventPattern<TSender, T> second)
		{
			return !object.Equals(first, second);
		}
	}
}
