﻿using System;

namespace System.Reactive.Disposables
{
	public sealed class SingleAssignmentDisposable : ICancelable, IDisposable
	{
		public bool IsDisposed
		{
			get
			{
				return global::System.Reactive.Disposables.Disposable.GetIsDisposed(ref this._current);
			}
		}

		public IDisposable Disposable
		{
			get
			{
				return global::System.Reactive.Disposables.Disposable.GetValueOrDefault(ref this._current);
			}
			set
			{
				global::System.Reactive.Disposables.Disposable.SetSingle(ref this._current, value);
			}
		}

		public void Dispose()
		{
			global::System.Reactive.Disposables.Disposable.TryDispose(ref this._current);
		}

		private IDisposable _current;
	}
}
