﻿using System;
using System.Reactive.Concurrency;

namespace System.Reactive.Disposables
{
	public sealed class ScheduledDisposable : ICancelable, IDisposable
	{
		public ScheduledDisposable(IScheduler scheduler, IDisposable disposable)
		{
			if (disposable == null)
			{
				throw new ArgumentNullException("disposable");
			}
			if (scheduler == null)
			{
				throw new ArgumentNullException("scheduler");
			}
			this.Scheduler = scheduler;
			global::System.Reactive.Disposables.Disposable.SetSingle(ref this._disposable, disposable);
		}

		public IScheduler Scheduler { get; }

		public IDisposable Disposable
		{
			get
			{
				return global::System.Reactive.Disposables.Disposable.GetValueOrDefault(ref this._disposable);
			}
		}

		public bool IsDisposed
		{
			get
			{
				return global::System.Reactive.Disposables.Disposable.GetIsDisposed(ref this._disposable);
			}
		}

		public void Dispose()
		{
			this.Scheduler.ScheduleAction(this, delegate(ScheduledDisposable scheduler)
			{
				global::System.Reactive.Disposables.Disposable.TryDispose(ref scheduler._disposable);
			});
		}

		private IDisposable _disposable;
	}
}
