﻿using System;
using System.Threading;

namespace System.Reactive.Disposables
{
	public sealed class CancellationDisposable : ICancelable, IDisposable
	{
		public CancellationDisposable(CancellationTokenSource cts)
		{
			if (cts == null)
			{
				throw new ArgumentNullException("cts");
			}
			this._cts = cts;
		}

		public CancellationDisposable()
			: this(new CancellationTokenSource())
		{
		}

		public CancellationToken Token
		{
			get
			{
				return this._cts.Token;
			}
		}

		public void Dispose()
		{
			this._cts.Cancel();
		}

		public bool IsDisposed
		{
			get
			{
				return this._cts.IsCancellationRequested;
			}
		}

		private readonly CancellationTokenSource _cts;
	}
}
