﻿using System;

namespace System.Reactive.Disposables
{
	public sealed class BooleanDisposable : ICancelable, IDisposable
	{
		public BooleanDisposable()
		{
		}

		private BooleanDisposable(bool isDisposed)
		{
			this._isDisposed = isDisposed;
		}

		public bool IsDisposed
		{
			get
			{
				return this._isDisposed;
			}
		}

		public void Dispose()
		{
			this._isDisposed = true;
		}

		internal static readonly BooleanDisposable True = new BooleanDisposable(true);

		private volatile bool _isDisposed;
	}
}
