﻿using System;
using System.Threading;

namespace System.Reactive.Disposables
{
	internal sealed class AnonymousDisposable : ICancelable, IDisposable
	{
		public AnonymousDisposable(Action dispose)
		{
			this._dispose = dispose;
		}

		public bool IsDisposed
		{
			get
			{
				return this._dispose == null;
			}
		}

		public void Dispose()
		{
			Action action = Interlocked.Exchange<Action>(ref this._dispose, null);
			if (action == null)
			{
				return;
			}
			action();
		}

		private volatile Action _dispose;
	}
}
