﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive.Concurrency
{
	public static class VirtualTimeSchedulerExtensions
	{
		public static IDisposable ScheduleRelative<T, U>(this VirtualTimeSchedulerBase<T, U> scheduler, U dueTime, Action action) where T : IComparable<T>
		{
			if (scheduler == null)
			{
				throw new ArgumentNullException("scheduler");
			}
			if (action == null)
			{
				throw new ArgumentNullException("action");
			}
			return scheduler.ScheduleRelative<Action>(action, dueTime, (IScheduler s, Action a) => VirtualTimeSchedulerExtensions.Invoke(s, a));
		}

		public static IDisposable ScheduleAbsolute<T, U>(this VirtualTimeSchedulerBase<T, U> scheduler, T dueTime, Action action) where T : IComparable<T>
		{
			if (scheduler == null)
			{
				throw new ArgumentNullException("scheduler");
			}
			if (action == null)
			{
				throw new ArgumentNullException("action");
			}
			return scheduler.ScheduleAbsolute<Action>(action, dueTime, (IScheduler s, Action a) => VirtualTimeSchedulerExtensions.Invoke(s, a));
		}

		private static IDisposable Invoke(IScheduler scheduler, Action action)
		{
			action();
			return Disposable.Empty;
		}
	}
}
