﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Concurrency
{
	public abstract class VirtualTimeScheduler<T, U> : VirtualTimeSchedulerBase<T, U> where T : IComparable<T>
	{
		protected VirtualTimeScheduler()
		{
		}

		protected VirtualTimeScheduler(T initialClock, IComparer<T> comparer)
			: base(initialClock, comparer)
		{
		}

		protected override IScheduledItem<T> GetNext()
		{
			SchedulerQueue<T> queue = this._queue;
			lock (queue)
			{
				while (this._queue.Count > 0)
				{
					ScheduledItem<T> scheduledItem = this._queue.Peek();
					if (!scheduledItem.IsCanceled)
					{
						return scheduledItem;
					}
					this._queue.Dequeue();
				}
				goto IL_0053;
			}
			IScheduledItem<T> scheduledItem2;
			return scheduledItem2;
			IL_0053:
			return null;
		}

		public override IDisposable ScheduleAbsolute<TState>(TState state, T dueTime, Func<IScheduler, TState, IDisposable> action)
		{
			if (action == null)
			{
				throw new ArgumentNullException("action");
			}
			ScheduledItem<T, TState> si = null;
			Func<IScheduler, TState, IDisposable> func = delegate(IScheduler scheduler, TState state1)
			{
				SchedulerQueue<T> queue2 = this._queue;
				lock (queue2)
				{
					this._queue.Remove(si);
				}
				return action(scheduler, state1);
			};
			si = new ScheduledItem<T, TState>(this, state, func, dueTime, base.Comparer);
			SchedulerQueue<T> queue = this._queue;
			lock (queue)
			{
				this._queue.Enqueue(si);
			}
			return si;
		}

		private readonly SchedulerQueue<T> _queue = new SchedulerQueue<T>();
	}
}
