﻿using System;
using System.Threading;
using System.Threading.Tasks;

namespace System.Reactive.Concurrency
{
	internal static class TaskHelpers
	{
		public static Task Delay(TimeSpan delay, CancellationToken token)
		{
			if ((long)delay.TotalMilliseconds > 2147483647L)
			{
				TimeSpan remainder = delay - TimeSpan.FromMilliseconds(2147483647.0);
				return Task.Delay(int.MaxValue, token).ContinueWith<Task>((Task _) => TaskHelpers.Delay(remainder, token), TaskContinuationOptions.ExecuteSynchronously).Unwrap();
			}
			return Task.Delay(delay, token);
		}
	}
}
