﻿using System;

namespace System.Reactive.Concurrency
{
	public class SchedulerQueue<T> where T : IComparable<T>
	{
		public SchedulerQueue()
			: this(1024)
		{
		}

		public SchedulerQueue(int capacity)
		{
			if (capacity < 0)
			{
				throw new ArgumentOutOfRangeException("capacity");
			}
			this._queue = new PriorityQueue<ScheduledItem<T>>(capacity);
		}

		public int Count
		{
			get
			{
				return this._queue.Count;
			}
		}

		public void Enqueue(ScheduledItem<T> scheduledItem)
		{
			this._queue.Enqueue(scheduledItem);
		}

		public bool Remove(ScheduledItem<T> scheduledItem)
		{
			return this._queue.Remove(scheduledItem);
		}

		public ScheduledItem<T> Dequeue()
		{
			return this._queue.Dequeue();
		}

		public ScheduledItem<T> Peek()
		{
			return this._queue.Peek();
		}

		private readonly PriorityQueue<ScheduledItem<T>> _queue;
	}
}
