﻿using System;
using System.Threading;

namespace System.Reactive.Concurrency
{
	public sealed class SchedulerOperation
	{
		internal SchedulerOperation(Func<Action, IDisposable> schedule, CancellationToken cancellationToken)
			: this(schedule, cancellationToken, false)
		{
		}

		internal SchedulerOperation(Func<Action, IDisposable> schedule, CancellationToken cancellationToken, bool postBackToOriginalContext)
		{
			this._schedule = schedule;
			this._cancellationToken = cancellationToken;
			this._postBackToOriginalContext = postBackToOriginalContext;
		}

		public SchedulerOperation ConfigureAwait(bool continueOnCapturedContext)
		{
			return new SchedulerOperation(this._schedule, this._cancellationToken, continueOnCapturedContext);
		}

		public SchedulerOperationAwaiter GetAwaiter()
		{
			return new SchedulerOperationAwaiter(this._schedule, this._cancellationToken, this._postBackToOriginalContext);
		}

		private readonly Func<Action, IDisposable> _schedule;

		private readonly CancellationToken _cancellationToken;

		private readonly bool _postBackToOriginalContext;
	}
}
