﻿using System;
using System.Collections.Generic;

namespace System.Reactive.Concurrency
{
	public sealed class ScheduledItem<T, TValue> : ScheduledItem<T> where T : IComparable<T>
	{
		public ScheduledItem(IScheduler scheduler, TValue state, Func<IScheduler, TValue, IDisposable> action, T dueTime, IComparer<T> comparer)
			: base(dueTime, comparer)
		{
			if (scheduler == null)
			{
				throw new ArgumentNullException("scheduler");
			}
			this._scheduler = scheduler;
			this._state = state;
			if (action == null)
			{
				throw new ArgumentNullException("action");
			}
			this._action = action;
		}

		public ScheduledItem(IScheduler scheduler, TValue state, Func<IScheduler, TValue, IDisposable> action, T dueTime)
			: this(scheduler, state, action, dueTime, Comparer<T>.Default)
		{
		}

		protected override IDisposable InvokeCore()
		{
			return this._action(this._scheduler, this._state);
		}

		private readonly IScheduler _scheduler;

		private readonly TValue _state;

		private readonly Func<IScheduler, TValue, IDisposable> _action;
	}
}
