﻿using System;
using System.ComponentModel;

namespace System.Reactive.Concurrency
{
	[EditorBrowsable(EditorBrowsableState.Never)]
	public interface IConcurrencyAbstractionLayer
	{
		IDisposable StartTimer(Action<object> action, object state, TimeSpan dueTime);

		IDisposable StartPeriodicTimer(Action action, TimeSpan period);

		IDisposable QueueUserWorkItem(Action<object> action, object state);

		void Sleep(TimeSpan timeout);

		IStopwatch StartStopwatch();

		bool SupportsLongRunning { get; }

		void StartThread(Action<object> action, object state);
	}
}
