﻿using System;
using System.Collections.Generic;
using System.Diagnostics;

namespace System.Reactive.Concurrency
{
	[DebuggerDisplay("\\{ Clock = {Clock} Now = {Now.ToString(\"O\")} \\}")]
	public class HistoricalScheduler : HistoricalSchedulerBase
	{
		public HistoricalScheduler()
		{
		}

		public HistoricalScheduler(DateTimeOffset initialClock)
			: base(initialClock)
		{
		}

		public HistoricalScheduler(DateTimeOffset initialClock, IComparer<DateTimeOffset> comparer)
			: base(initialClock, comparer)
		{
		}

		protected override IScheduledItem<DateTimeOffset> GetNext()
		{
			while (this._queue.Count > 0)
			{
				ScheduledItem<DateTimeOffset> scheduledItem = this._queue.Peek();
				if (!scheduledItem.IsCanceled)
				{
					return scheduledItem;
				}
				this._queue.Dequeue();
			}
			return null;
		}

		public override IDisposable ScheduleAbsolute<TState>(TState state, DateTimeOffset dueTime, Func<IScheduler, TState, IDisposable> action)
		{
			if (action == null)
			{
				throw new ArgumentNullException("action");
			}
			ScheduledItem<DateTimeOffset, TState> si = null;
			Func<IScheduler, TState, IDisposable> func = delegate(IScheduler scheduler, TState state1)
			{
				this._queue.Remove(si);
				return action(scheduler, state1);
			};
			si = new ScheduledItem<DateTimeOffset, TState>(this, state, func, dueTime, base.Comparer);
			this._queue.Enqueue(si);
			return si;
		}

		private readonly SchedulerQueue<DateTimeOffset> _queue = new SchedulerQueue<DateTimeOffset>();
	}
}
