﻿using System;
using System.Linq;
using System.Runtime.CompilerServices;

namespace System.Reactive.Concurrency
{
	internal sealed class DisableOptimizationsScheduler : SchedulerWrapper
	{
		public DisableOptimizationsScheduler(IScheduler scheduler)
			: base(scheduler)
		{
			this._optimizationInterfaces = Scheduler.Optimizations;
		}

		public DisableOptimizationsScheduler(IScheduler scheduler, Type[] optimizationInterfaces)
			: base(scheduler)
		{
			this._optimizationInterfaces = optimizationInterfaces;
		}

		public DisableOptimizationsScheduler(IScheduler scheduler, Type[] optimizationInterfaces, ConditionalWeakTable<IScheduler, IScheduler> cache)
			: base(scheduler, cache)
		{
			this._optimizationInterfaces = optimizationInterfaces;
		}

		protected override SchedulerWrapper Clone(IScheduler scheduler, ConditionalWeakTable<IScheduler, IScheduler> cache)
		{
			return new DisableOptimizationsScheduler(scheduler, this._optimizationInterfaces, cache);
		}

		protected override bool TryGetService(IServiceProvider provider, Type serviceType, out object service)
		{
			service = null;
			return this._optimizationInterfaces.Contains(serviceType);
		}

		private readonly Type[] _optimizationInterfaces;
	}
}
