﻿using System;
using System.Collections.Generic;

namespace System.Reactive
{
	internal abstract class ConcatSink<TSource> : TailRecursiveSink<TSource>
	{
		protected ConcatSink(IObserver<TSource> observer)
			: base(observer)
		{
		}

		protected override IEnumerable<IObservable<TSource>> Extract(IObservable<TSource> source)
		{
			IConcatenatable<TSource> concatenatable = source as IConcatenatable<TSource>;
			if (concatenatable == null)
			{
				return null;
			}
			return concatenatable.GetSources();
		}

		public override void OnCompleted()
		{
			base.Recurse();
		}
	}
}
