﻿using System;
using System.Runtime.CompilerServices;

namespace System.Reactive
{
	internal sealed class BinaryObserver<TLeft, TRight> : IObserver<Either<Notification<TLeft>, Notification<TRight>>>
	{
		public BinaryObserver(IObserver<TLeft> leftObserver, IObserver<TRight> rightObserver)
		{
			this.LeftObserver = leftObserver;
			this.RightObserver = rightObserver;
		}

		public BinaryObserver(Action<Notification<TLeft>> left, Action<Notification<TRight>> right)
			: this(left.ToObserver<TLeft>(), right.ToObserver<TRight>())
		{
		}

		public IObserver<TLeft> LeftObserver { get; }

		public IObserver<TRight> RightObserver { get; }

		void IObserver<Either<Notification<TLeft>, Notification<TRight>>>.OnNext(Either<Notification<TLeft>, Notification<TRight>> value)
		{
			value.Switch(new Action<Notification<TLeft>>(this.method_0), new Action<Notification<TRight>>(this.method_1));
		}

		void IObserver<Either<Notification<TLeft>, Notification<TRight>>>.OnError(Exception exception)
		{
		}

		void IObserver<Either<Notification<TLeft>, Notification<TRight>>>.OnCompleted()
		{
		}

		[CompilerGenerated]
		private void method_0(Notification<TLeft> left)
		{
			left.Accept(this.LeftObserver);
		}

		[CompilerGenerated]
		private void method_1(Notification<TRight> right)
		{
			right.Accept(this.RightObserver);
		}
	}
}
