﻿using System;
using System.Reactive.Concurrency;
using System.Runtime.CompilerServices;

namespace System.Reactive
{
	internal sealed class AsyncLockObserver<T> : ObserverBase<T>
	{
		public AsyncLockObserver(IObserver<T> observer, AsyncLock gate)
		{
			this._gate = gate;
			this._observer = observer;
		}

		protected override void OnNextCore(T value)
		{
			this._gate.Wait<ValueTuple<IObserver<T>, T>>(new ValueTuple<IObserver<T>, T>(this._observer, value), delegate([TupleElementNames(new string[] { "_observer", "value" })] ValueTuple<IObserver<T>, T> tuple)
			{
				tuple.Item1.OnNext(tuple.Item2);
			});
		}

		protected override void OnErrorCore(Exception exception)
		{
			this._gate.Wait<ValueTuple<IObserver<T>, Exception>>(new ValueTuple<IObserver<T>, Exception>(this._observer, exception), delegate([TupleElementNames(new string[] { "_observer", "exception" })] ValueTuple<IObserver<T>, Exception> tuple)
			{
				tuple.Item1.OnError(tuple.Item2);
			});
		}

		protected override void OnCompletedCore()
		{
			this._gate.Wait<IObserver<T>>(this._observer, delegate(IObserver<T> closureObserver)
			{
				closureObserver.OnCompleted();
			});
		}

		private readonly AsyncLock _gate;

		private readonly IObserver<T> _observer;
	}
}
