﻿using System;
using System.Reactive.Disposables;

namespace System.Reactive
{
	public sealed class AnonymousObservable<T> : ObservableBase<T>
	{
		public AnonymousObservable(Func<IObserver<T>, IDisposable> subscribe)
		{
			if (subscribe == null)
			{
				throw new ArgumentNullException("subscribe");
			}
			this._subscribe = subscribe;
		}

		protected override IDisposable SubscribeCore(IObserver<T> observer)
		{
			return this._subscribe(observer) ?? Disposable.Empty;
		}

		private readonly Func<IObserver<T>, IDisposable> _subscribe;
	}
}
