﻿using System;
using System.Collections;
using System.Collections.Generic;

namespace System.Reactive
{
	internal sealed class AnonymousEnumerable<T> : IEnumerable<T>, IEnumerable
	{
		public AnonymousEnumerable(Func<IEnumerator<T>> getEnumerator)
		{
			this._getEnumerator = getEnumerator;
		}

		public IEnumerator<T> GetEnumerator()
		{
			return this._getEnumerator();
		}

		IEnumerator IEnumerable.GetEnumerator()
		{
			return this._getEnumerator();
		}

		private readonly Func<IEnumerator<T>> _getEnumerator;
	}
}
