﻿using System;
using System.Diagnostics;
using System.Reflection;
using System.Text;
using System.Timers;
using NinjaTrader.Cbi;
using NinjaTrader.Gui.AccountData;

namespace Replikanto
{
	internal class SlaveAccount : AccountGridEntry, IEquatable<SlaveAccount>
	{
		protected override void Finalize()
		{
			try
			{
				this.Clear();
			}
			finally
			{
				Delegate196.smethod_0(this, Delegate196.delegate196_0);
			}
		}

		public SlaveAccount(Account account, ReplikantoTabPage tabPage)
		{
			if (account == null)
			{
				throw new NullReferenceException("Slave Account cannot be null");
			}
			this.GcxEvpJiTW = tabPage;
			Delegate199.smethod_0(this, account, Delegate199.delegate199_0);
			Delegate202.smethod_0(this, Delegate201.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate201.delegate201_0), Delegate202.delegate202_0);
			Delegate206.smethod_0(this, Delegate205.smethod_0(Delegate204.smethod_0(Delegate203.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate203.delegate203_0), Delegate204.delegate204_0), Delegate205.delegate205_0), Delegate206.delegate206_0);
			Delegate210.smethod_0(this, Delegate209.smethod_0(Delegate208.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), 1, Delegate207.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate207.delegate207_0), Delegate208.delegate208_0), Delegate209.delegate209_0), Delegate210.delegate210_0);
			Delegate211.smethod_0(this, Delegate209.smethod_0(Delegate208.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), 15, Delegate207.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate207.delegate207_0), Delegate208.delegate208_0), Delegate209.delegate209_0), Delegate211.delegate211_0);
			this.Ratio = 1.0;
			this.UseATM = false;
			this.MarketOnly = false;
			this.Status = FollowerAccountStatus.Off;
			this.position_0 = null;
			this.marketPosition_0 = 2;
		}

		public FollowerAccountStatus Status
		{
			get
			{
				return this.followerAccountStatus_0;
			}
			set
			{
				this.followerAccountStatus_0 = value;
				if (value != FollowerAccountStatus.Off)
				{
					if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null)
					{
						Delegate212.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<PositionEventArgs>(this.method_0), Delegate212.Dyqofvotxu);
						Delegate214.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<PositionEventArgs>(this.method_0), Delegate214.delegate214_0);
						Delegate213.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<AccountItemEventArgs>(this.fmkEsCykxV), Delegate213.delegate213_0);
						Delegate215.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<AccountItemEventArgs>(this.fmkEsCykxV), Delegate215.delegate215_0);
					}
					this.method_1();
				}
				else
				{
					if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null)
					{
						Delegate212.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<PositionEventArgs>(this.method_0), Delegate212.Dyqofvotxu);
						Delegate213.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<AccountItemEventArgs>(this.fmkEsCykxV), Delegate213.delegate213_0);
					}
					this.marketPosition_0 = 2;
				}
				this.RefreshPnL(false);
				Delegate216.smethod_0(this, "Status", Delegate216.delegate216_0);
				Delegate216.smethod_0(this, "Side", Delegate216.delegate216_0);
				Delegate216.smethod_0(this, "Quantity", Delegate216.delegate216_0);
				Delegate216.smethod_0(this, "AveragePrice", Delegate216.delegate216_0);
			}
		}

		public MarketPosition MarketPosition
		{
			get
			{
				return this.marketPosition_0;
			}
		}

		public bool CrossOrder
		{
			get
			{
				return this.bool_0;
			}
			set
			{
				this.bool_0 = value;
				this.RefreshPnL(true);
				Delegate216.smethod_0(this, "CrossOrder", Delegate216.delegate216_0);
			}
		}

		public bool MarketOnly
		{
			get
			{
				return this.bool_1;
			}
			set
			{
				this.bool_1 = value;
				Delegate216.smethod_0(this, "MarketOnly", Delegate216.delegate216_0);
			}
		}

		public bool UseATM
		{
			get
			{
				return this.bool_2;
			}
			set
			{
				this.bool_2 = value;
				Delegate216.smethod_0(this, "UseATM", Delegate216.delegate216_0);
			}
		}

		public double FactorAvailableEquity
		{
			get
			{
				return this.double_0;
			}
		}

		public void SetFactorAvailableEquity(double f)
		{
			this.double_0 = f;
			Delegate216.smethod_0(this, "FactorAvailableEquity", Delegate216.delegate216_0);
		}

		public double FactorNetLiq
		{
			get
			{
				return this.double_1;
			}
		}

		public void SetFactorNetLiq(double f)
		{
			this.double_1 = f;
			Delegate216.smethod_0(this, "FactorNetLiq", Delegate216.delegate216_0);
		}

		public double PctField
		{
			get
			{
				return this.double_2;
			}
			set
			{
				this.double_2 = value;
				Delegate216.smethod_0(this, "PctField", Delegate216.delegate216_0);
			}
		}

		public double Ratio
		{
			get
			{
				return this.double_3;
			}
			set
			{
				this.double_3 = value;
				Delegate216.smethod_0(this, "Ratio", Delegate216.delegate216_0);
			}
		}

		public ushort PreAllocation
		{
			get
			{
				return this.ushort_0;
			}
			set
			{
				this.ushort_0 = value;
				Delegate216.smethod_0(this, "PreAllocation", Delegate216.delegate216_0);
			}
		}

		public bool Connected
		{
			get
			{
				Account account = Delegate200.smethod_0(this, Delegate200.delegate200_0);
				return account != null && Delegate217.smethod_0(account, Delegate217.delegate217_0) == 3;
			}
		}

		public bool ShowAccountNumber
		{
			get
			{
				return this.bool_3;
			}
			set
			{
				this.bool_3 = value;
				Delegate216.smethod_0(this, "AccountDisplay", Delegate216.delegate216_0);
			}
		}

		public double PnL
		{
			get
			{
				return this.double_4;
			}
			set
			{
				if (value != this.double_4)
				{
					this.double_4 = value;
					Delegate216.smethod_0(this, "PnL", Delegate216.delegate216_0);
					Delegate216.smethod_0(this, "PnLValue", Delegate216.delegate216_0);
				}
			}
		}

		public string PnLValue
		{
			get
			{
				if (!Delegate218.smethod_0(this.double_4, Delegate218.delegate218_0) && this.Status != FollowerAccountStatus.Off)
				{
					return Delegate219.smethod_0(this.PnL, Delegate207.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate207.delegate207_0), Delegate219.delegate219_0);
				}
				return string.Empty;
			}
		}

		public string Side
		{
			get
			{
				if (this.marketPosition_0 != 2 && this.Status != FollowerAccountStatus.Off)
				{
					return this.marketPosition_0.ToString();
				}
				return string.Empty;
			}
		}

		public string Quantity
		{
			get
			{
				if (this.position_0 != null && this.Status != FollowerAccountStatus.Off)
				{
					int num = Delegate193.smethod_0(this.position_0, Delegate193.delegate193_0);
					return Delegate220.smethod_0(ref num, Delegate220.xReoabdegl);
				}
				return string.Empty;
			}
		}

		public double AveragePrice
		{
			get
			{
				if (this.position_0 != null && this.Status != FollowerAccountStatus.Off)
				{
					return Delegate194.smethod_0(this.position_0, Delegate194.delegate194_0);
				}
				return 0.0;
			}
		}

		public string AccountDisplay
		{
			get
			{
				if (this.ShowAccountNumber)
				{
					return Delegate221.smethod_0(this, Delegate221.delegate221_0);
				}
				string text;
				try
				{
					text = Delegate50.smethod_0("{0}{1}{2}", Delegate101.smethod_0(Delegate221.smethod_0(this, Delegate221.delegate221_0), 0, 2, Delegate101.delegate101_0), new string('*', Delegate99.smethod_0(Delegate221.smethod_0(this, Delegate221.delegate221_0), Delegate99.delegate99_0) - 4), Delegate101.smethod_0(Delegate221.smethod_0(this, Delegate221.delegate221_0), Delegate99.smethod_0(Delegate221.smethod_0(this, Delegate221.delegate221_0), Delegate99.delegate99_0) - 2, 2, Delegate101.delegate101_0), Delegate50.delegate50_0);
				}
				catch
				{
					text = Delegate221.smethod_0(this, Delegate221.delegate221_0);
				}
				return text;
			}
			set
			{
				Delegate202.smethod_0(this, value, Delegate202.delegate202_0);
				Delegate216.smethod_0(this, "Account", Delegate216.delegate216_0);
			}
		}

		private void fmkEsCykxV(object sender, AccountItemEventArgs e)
		{
			if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null)
			{
				if (Delegate192.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate192.delegate192_0) == Delegate192.smethod_0(sender, Delegate192.delegate192_0))
				{
					if (Delegate222.smethod_0(e, Delegate222.delegate222_0) == 1)
					{
						Delegate210.smethod_0(this, Delegate209.smethod_0(e, Delegate209.delegate209_0), Delegate210.delegate210_0);
						Delegate216.smethod_0(this, "CashValue", Delegate216.delegate216_0);
						return;
					}
					if (Delegate222.smethod_0(e, Delegate222.delegate222_0) == 15)
					{
						Delegate211.smethod_0(this, Delegate209.smethod_0(e, Delegate209.delegate209_0), Delegate211.delegate211_0);
						Delegate216.smethod_0(this, "NetLiquidation", Delegate216.delegate216_0);
						return;
					}
					if (Delegate222.smethod_0(e, Delegate222.delegate222_0) == 23)
					{
						this.RefreshPnL(false);
					}
					return;
				}
			}
		}

		private void method_0(object sender, PositionEventArgs e)
		{
			try
			{
				Instrument instrument = ((!this.CrossOrder || !this.GcxEvpJiTW.isCrossOrderChecked) ? this.GcxEvpJiTW.Instrument : this.GcxEvpJiTW.CrossOrderInstrument);
				if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null && instrument != null && Delegate225.smethod_0(Delegate224.smethod_0(Delegate223.smethod_0(e, Delegate223.delegate223_0), Delegate224.delegate224_0), Delegate225.delegate225_0) == Delegate225.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate225.delegate225_0))
				{
					if (Delegate186.smethod_0(Delegate226.smethod_0(Delegate223.smethod_0(e, Delegate223.delegate223_0), Delegate226.delegate226_0), Delegate186.delegate186_0) == Delegate186.smethod_0(instrument, Delegate186.delegate186_0))
					{
						this.marketPosition_0 = Delegate227.smethod_0(e, Delegate227.delegate227_0);
						if (this.marketPosition_0 == 2)
						{
							this.position_0 = null;
						}
						else
						{
							this.position_0 = Delegate223.smethod_0(e, Delegate223.delegate223_0);
						}
						this.RefreshPnL(false);
						Delegate216.smethod_0(this, "Side", Delegate216.delegate216_0);
						Delegate216.smethod_0(this, "Quantity", Delegate216.delegate216_0);
						Delegate216.smethod_0(this, "AveragePrice", Delegate216.delegate216_0);
					}
				}
			}
			catch
			{
			}
		}

		private void method_1()
		{
			try
			{
				if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null)
				{
					Instrument instrument = ((!this.CrossOrder || !this.GcxEvpJiTW.isCrossOrderChecked) ? this.GcxEvpJiTW.Instrument : this.GcxEvpJiTW.CrossOrderInstrument);
					if (instrument == null)
					{
						this.position_0 = null;
					}
					else
					{
						this.position_0 = Delegate228.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), Delegate186.smethod_0(instrument, Delegate186.delegate186_0), Delegate228.delegate228_0);
						if (this.position_0 == null)
						{
							this.marketPosition_0 = 2;
						}
						else
						{
							this.marketPosition_0 = Delegate195.smethod_0(this.position_0, Delegate195.delegate195_0);
							if (this.marketPosition_0 == 2)
							{
								this.position_0 = null;
							}
						}
					}
				}
				else
				{
					this.position_0 = null;
				}
			}
			catch
			{
				this.position_0 = null;
			}
		}

		internal void RefreshPnL(bool forceUpdate = false)
		{
			try
			{
				if (forceUpdate)
				{
					if (!Delegate218.smethod_0(this.PnL, Delegate218.delegate218_0))
					{
						this.PnL = double.NaN;
					}
					this.method_1();
				}
				if (this.Status != FollowerAccountStatus.Off && this.GcxEvpJiTW.ReplikantoProperties.Boolean_0)
				{
					if (this.marketPosition_0 == 2)
					{
						if (!Delegate218.smethod_0(this.PnL, Delegate218.delegate218_0))
						{
							this.PnL = double.NaN;
							goto IL_00CF;
						}
						goto IL_00CF;
					}
					else
					{
						try
						{
							if (this.position_0 != null)
							{
								this.PnL = Delegate229.smethod_0(this.position_0, 0, double.MinValue, Delegate229.delegate229_0);
							}
							goto IL_00CF;
						}
						catch
						{
							this.PnL = double.NaN;
							goto IL_00CF;
						}
					}
				}
				if (!Delegate218.smethod_0(this.PnL, Delegate218.delegate218_0))
				{
					this.PnL = double.NaN;
				}
				IL_00CF:;
			}
			catch (Exception)
			{
				this.PnL = double.NaN;
			}
		}

		public bool Equals(SlaveAccount other)
		{
			Account account = Delegate230.smethod_0(other, Delegate230.delegate230_0);
			long? num = ((account == null) ? null : new long?(Delegate231.smethod_0(account, Delegate231.delegate231_0)));
			Account account2 = Delegate200.smethod_0(this, Delegate200.delegate200_0);
			long? num2 = ((account2 != null) ? new long?(Delegate231.smethod_0(account2, Delegate231.delegate231_0)) : null);
			return (num.GetValueOrDefault() == num2.GetValueOrDefault()) & (num != null == (num2 != null));
		}

		[Conditional("Debug")]
		private void method_2(string string_0)
		{
			Delegate83.smethod_0(string_0, 0, Delegate83.delegate83_0);
		}

		public override string ToString()
		{
			PropertyInfo[] array = Delegate166.smethod_0(Delegate165.smethod_0(this, Delegate165.delegate165_0), Delegate166.delegate166_0);
			StringBuilder stringBuilder = new StringBuilder();
			foreach (PropertyInfo propertyInfo in array)
			{
				Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate169.smethod_0(propertyInfo, this, Delegate169.delegate169_0), Delegate170.delegate170_0);
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		public void Clear()
		{
			if (Delegate200.smethod_0(this, Delegate200.delegate200_0) != null)
			{
				Delegate213.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<AccountItemEventArgs>(this.fmkEsCykxV), Delegate213.delegate213_0);
				Delegate212.smethod_0(Delegate200.smethod_0(this, Delegate200.delegate200_0), new EventHandler<PositionEventArgs>(this.method_0), Delegate212.Dyqofvotxu);
			}
			if (this.outOfSyncTimer != null)
			{
				try
				{
					Delegate28.smethod_0(this.outOfSyncTimer, Delegate28.delegate28_0);
					Delegate35.smethod_0(this.outOfSyncTimer, Delegate35.delegate35_0);
				}
				catch
				{
				}
			}
			if (this.opositeDirectionTimer != null)
			{
				try
				{
					Delegate28.smethod_0(this.opositeDirectionTimer, Delegate28.delegate28_0);
					Delegate35.smethod_0(this.opositeDirectionTimer, Delegate35.delegate35_0);
				}
				catch
				{
				}
			}
			this.position_0 = null;
			this.marketPosition_0 = 2;
		}

		internal static void smethod_0()
		{
		}

		internal static void smethod_1()
		{
		}

		internal static object smethod_2(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_3(object object_0)
		{
			return object_0.Instrument;
		}

		internal static object smethod_4(object object_0)
		{
			return object_0.ReplikantoProperties;
		}

		internal static void smethod_5()
		{
		}

		public Timer outOfSyncTimer;

		public Timer opositeDirectionTimer;

		private ReplikantoTabPage GcxEvpJiTW;

		private Position position_0;

		private MarketPosition marketPosition_0 = 2;

		private FollowerAccountStatus followerAccountStatus_0;

		private bool bool_0;

		private bool bool_1;

		private bool bool_2;

		private double double_0;

		private double double_1;

		private double double_2;

		private double double_3;

		private ushort ushort_0;

		private bool bool_3 = Delegate198.smethod_0(Delegate197.smethod_0(Delegate197.delegate197_0), Delegate198.delegate198_0);

		private double double_4 = double.NaN;
	}
}
