﻿using System;
using System.CodeDom.Compiler;
using System.Collections;
using System.Collections.Concurrent;
using System.ComponentModel;
using System.Diagnostics;
using System.Runtime.CompilerServices;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Forms;
using System.Windows.Input;
using System.Windows.Markup;
using System.Xml.Linq;
using NinjaTrader.Cbi;
using NinjaTrader.Gui.HotKeys;
using NinjaTrader.Gui.Tools;
using NinjaTrader.NinjaScript.AddOns.FlowBots;
using Replikanto.Properties;

namespace Replikanto
{
	public partial class ReplikantoWindow : NTWindow, IWorkspacePersistence, ITabHotKeys, IHotKeysConsumer
	{
		public ReplikantoWindow()
		{
			ReplikantoFramework.ServerActiveCheck();
			this.InitializeComponent();
			Delegate551.smethod_0(this.tabControl, new ReplikantoTabPage(), -1, Delegate551.delegate551_0);
		}

		protected override void Finalize()
		{
			try
			{
			}
			finally
			{
				Delegate196.smethod_0(this, Delegate196.delegate196_0);
			}
		}

		public string CustomWindowTitle { get; set; }

		public WorkspaceOptions WorkspaceOptions { get; set; }

		public void OnCloseOtherTabs()
		{
		}

		public void OnCloseTab()
		{
		}

		public void OnDuplicateInNewTab()
		{
		}

		public void OnDuplicateInNewWindow()
		{
		}

		public void OnMoveToNewWindow()
		{
		}

		public void Restore(XDocument document, XElement element)
		{
			if (Delegate552.smethod_0(this, Delegate552.delegate552_0) != null)
			{
				Delegate553.smethod_0(Delegate552.smethod_0(this, Delegate552.delegate552_0), element, Delegate553.delegate553_0);
			}
		}

		public void Save(XDocument document, XElement element)
		{
			if (Delegate552.smethod_0(this, Delegate552.delegate552_0) != null)
			{
				Delegate554.smethod_0(Delegate552.smethod_0(this, Delegate552.delegate552_0), element, Delegate554.delegate554_0);
			}
		}

		private void method_0(object sender, RoutedEventArgs e)
		{
		}

		private void method_1(object sender, RoutedEventArgs e)
		{
			if (this.WorkspaceOptions == null)
			{
				string addOnName = Resources.AddOnName;
				string text = "-";
				Guid guid = Delegate176.smethod_0(Delegate176.delegate176_0);
				this.WorkspaceOptions = new WorkspaceOptions(Delegate51.smethod_0(addOnName, text, Delegate555.smethod_0(ref guid, "N", Delegate555.delegate555_0), Delegate51.delegate51_0), this);
			}
			Delegate74.smethod_0(Delegate274.smethod_0(this, Delegate274.delegate274_0), new Action(this.method_8), Array.Empty<object>(), Delegate74.delegate74_0);
		}

		public global::System.Windows.Controls.TabControl TabControl
		{
			get
			{
				return this.tabControl;
			}
		}

		private void method_2(object sender, EventArgs e)
		{
		}

		private void method_3(object sender, TextCompositionEventArgs e)
		{
		}

		private void method_4(object sender, EventArgs e)
		{
		}

		private void method_5(object sender, EventArgs e)
		{
		}

		private void method_6(object sender, EventArgs e)
		{
		}

		public void SetOrderAs(long id, ScalperTicketOrderType orderType)
		{
			if (orderType > ScalperTicketOrderType.Unknow)
			{
				try
				{
					if (ReplikantoWindow.concurrentDictionary_0.TryAdd(id, orderType))
					{
						Delegate34.smethod_0(Delegate82.smethod_0("Replikanto: Order {0} as {1}", id, orderType, Delegate82.delegate82_0), 1, Delegate34.delegate34_0);
					}
				}
				catch
				{
				}
			}
		}

		internal static ScalperTicketOrderType GetScalperTicketOrderType(long id)
		{
			ScalperTicketOrderType scalperTicketOrderType2;
			try
			{
				ScalperTicketOrderType scalperTicketOrderType;
				if (!ReplikantoWindow.concurrentDictionary_0.TryGetValue(id, out scalperTicketOrderType))
				{
					return ScalperTicketOrderType.Unknow;
				}
				scalperTicketOrderType2 = scalperTicketOrderType;
			}
			catch
			{
				return ScalperTicketOrderType.Unknow;
			}
			return scalperTicketOrderType2;
		}

		internal static bool RemoveScalperTicketOrderType(long id)
		{
			try
			{
				ScalperTicketOrderType scalperTicketOrderType;
				return ReplikantoWindow.concurrentDictionary_0.TryRemove(id, out scalperTicketOrderType);
			}
			catch
			{
			}
			return false;
		}

		public bool ExternalFlatAll(Account account, Instrument instrument)
		{
			ReplikantoWindow.<>c__DisplayClass30_0 CS$<>8__locals1 = new ReplikantoWindow.<>c__DisplayClass30_0();
			CS$<>8__locals1.account_0 = account;
			CS$<>8__locals1.instrument_0 = instrument;
			CS$<>8__locals1.bool_0 = false;
			IEnumerator enumerator = Delegate75.smethod_0(Delegate66.smethod_0(this.TabControl, Delegate66.delegate66_0), Delegate75.delegate75_0);
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					ReplikantoWindow.<>c__DisplayClass30_1 CS$<>8__locals2 = new ReplikantoWindow.<>c__DisplayClass30_1();
					CS$<>8__locals2.<>c__DisplayClass30_0_0 = CS$<>8__locals1;
					CS$<>8__locals2.tabItem_0 = (TabItem)Delegate76.smethod_0(enumerator, Delegate76.delegate76_0);
					Delegate274.smethod_0(this, Delegate274.delegate274_0).Invoke(new Action(CS$<>8__locals2.method_0));
				}
			}
			finally
			{
				IDisposable disposable = enumerator as IDisposable;
				if (disposable != null)
				{
					Delegate39.smethod_0(disposable, Delegate39.delegate39_0);
				}
			}
			return CS$<>8__locals1.bool_0;
		}

		[Conditional("Debug")]
		private void method_7(string string_1)
		{
			Delegate83.smethod_0(Delegate33.smethod_0("Window - ", string_1, Delegate33.delegate33_0), 0, Delegate83.delegate83_0);
		}

		[CompilerGenerated]
		private void method_8()
		{
			Version version = Delegate48.smethod_0(Delegate47.smethod_0(Delegate46.smethod_0(Delegate45.smethod_0(typeof(ReplikantoTabPage).TypeHandle, Delegate45.delegate45_0), Delegate46.delegate46_0), Delegate47.delegate47_0), Delegate48.delegate48_0);
			MessageBoxResult messageBoxResult = Delegate562.smethod_0(this, Resources.TermsOfUseText, Delegate51.smethod_0(Resources.AddOnHeader, " - ", Resources.TermsOfUseCaption, Delegate51.delegate51_0), MessageBoxButton.OK, MessageBoxImage.Exclamation, MessageBoxDefaultButton.Button1, Delegate82.smethod_0("{0}_{1}", Resources.AddOnName, Delegate50.smethod_0("{0}.{1}.{2}", Delegate52.smethod_0(version, Delegate52.delegate52_0), Delegate53.smethod_0(version, Delegate53.delegate53_0), Delegate54.smethod_0(version, Delegate54.delegate54_0), Delegate50.delegate50_0), Delegate82.delegate82_0), Resources.TermsOfUseUrl, Delegate562.delegate562_0);
			if (messageBoxResult != MessageBoxResult.OK && messageBoxResult != MessageBoxResult.None)
			{
				Delegate563.smethod_0(this, Delegate563.delegate563_0);
			}
		}

		internal static void smethod_0()
		{
		}

		internal static object smethod_1()
		{
			return Resources.AddOnName;
		}

		internal static object smethod_2(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_3(object object_0, object object_1)
		{
			object_0.Invoke(object_1);
		}

		internal static void smethod_4()
		{
		}

		internal static void smethod_5()
		{
		}

		internal static object smethod_6()
		{
			return Resources.AddOnHeader;
		}

		private static readonly ConcurrentDictionary<long, ScalperTicketOrderType> concurrentDictionary_0 = new ConcurrentDictionary<long, ScalperTicketOrderType>();

		[CompilerGenerated]
		private string string_0;

		[CompilerGenerated]
		private WorkspaceOptions workspaceOptions_0;
	}
}
