﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Net.NetworkInformation;
using System.Net.Sockets;
using System.Runtime.CompilerServices;
using System.Threading;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Tools;
using Replikanto.Properties;

namespace Replikanto
{
	[CategoryDefaultExpanded(true)]
	[CategoryOrder(typeof(Resources), "RemoteReplikantoInfo", 40)]
	[CategoryOrder(typeof(Resources), "RemoteLeaderFilterInfo", 50)]
	[CategoryOrder(typeof(Resources), "NetworkReplikantoInfo", 30)]
	[CategoryOrder(typeof(Resource), "PropertyCategoryGeneral", 10)]
	[CategoryOrder(typeof(Resources), "FollowerGuard", 20)]
	[CategoryOrder(typeof(Resource), "GuiVersion", 80)]
	[CategoryOrder(typeof(Resources), "PropertyCategoryColumns", 60)]
	[CategoryOrder(typeof(Resource), "PropertyCategoryWindow", 70)]
	public class ReplikantoProperties : NTTabPageProperties
	{
		public ReplikantoProperties()
		{
			ReplikantoProperties.smethod_0(new PropertyChangedEventHandler(this.method_0));
			this.OrderTypeWhenInvert = 4;
			this.OffSet = 1U;
			this.CreditAlert = 10U;
			this.LocalNetworkTimeout = 1200U;
			this.bool_12 = false;
			this.OnlyActiveWokspace = true;
			this.BlockCopy = false;
			this.ScalperTicketIntegration = true;
			this.TabName = "@INSTRUMENT_FULL";
			this.StealthMode = false;
			this.CancelEntry = false;
			this.CancelEntrySeconds = 5U;
			this.FlattenPositionOnOutOfSync = false;
			this.FlattenPositionOnOutOfSyncSeconds = 10U;
			this.FlattenPositionOnOppositeDirection = false;
			this.FlattenPositionOnOppositeDirectionSeconds = 5U;
			this.bool_7 = false;
			this.FlattenPositionOnSubmitError = false;
			this.FlattenPositionOnChangeError = false;
			this.FlattenPositionOnCancelError = false;
			this.FlattenPositionOnOtherError = false;
			this.FlattenPositionSecondsOnError = 3U;
			this.ConnectionColumn = false;
			this.Boolean_0 = true;
			this.CashValueColumn = false;
			this.SideColumn = true;
			this.QuantityColumn = true;
			this.AveragePriceColumn = true;
			this.DescriptionNodeColumn = true;
			this.DescriptionInternetNodeColumn = true;
			this.DisarmFollowers = true;
			this.NetworkAdapter = ReplikantoProperties.NetworkAdapterEnumConverter.GetFirst(null);
		}

		[CompilerGenerated]
		private static void smethod_0(PropertyChangedEventHandler value)
		{
			PropertyChangedEventHandler propertyChangedEventHandler = ReplikantoProperties.htBfnmetgc;
			PropertyChangedEventHandler propertyChangedEventHandler2;
			do
			{
				propertyChangedEventHandler2 = propertyChangedEventHandler;
				PropertyChangedEventHandler propertyChangedEventHandler3 = (PropertyChangedEventHandler)Delegate544.smethod_0(propertyChangedEventHandler2, value, Delegate544.delegate544_0);
				propertyChangedEventHandler = Interlocked.CompareExchange<PropertyChangedEventHandler>(ref ReplikantoProperties.htBfnmetgc, propertyChangedEventHandler3, propertyChangedEventHandler2);
			}
			while (propertyChangedEventHandler != propertyChangedEventHandler2);
		}

		[CompilerGenerated]
		private static void smethod_1(PropertyChangedEventHandler value)
		{
			PropertyChangedEventHandler propertyChangedEventHandler = ReplikantoProperties.htBfnmetgc;
			PropertyChangedEventHandler propertyChangedEventHandler2;
			do
			{
				propertyChangedEventHandler2 = propertyChangedEventHandler;
				PropertyChangedEventHandler propertyChangedEventHandler3 = (PropertyChangedEventHandler)Delegate545.smethod_0(propertyChangedEventHandler2, value, Delegate545.delegate545_0);
				propertyChangedEventHandler = Interlocked.CompareExchange<PropertyChangedEventHandler>(ref ReplikantoProperties.htBfnmetgc, propertyChangedEventHandler3, propertyChangedEventHandler2);
			}
			while (propertyChangedEventHandler != propertyChangedEventHandler2);
		}

		private static void smethod_2(object object_0)
		{
			ReplikantoProperties.htBfnmetgc(Delegate45.smethod_0(typeof(ReplikantoProperties).TypeHandle, Delegate45.delegate45_0), new PropertyChangedEventArgs(object_0));
		}

		private void method_0(object sender, PropertyChangedEventArgs e)
		{
			string text = Delegate278.smethod_0(e, Delegate278.delegate278_0);
			uint num = <PrivateImplementationDetails>.ComputeStringHash(text);
			if (num <= 1127555431U)
			{
				if (num != 261807733U)
				{
					if (num != 1066244646U)
					{
						if (num != 1127555431U)
						{
							return;
						}
						if (Delegate102.smethod_0(text, "Email", Delegate102.delegate102_0))
						{
							Delegate216.smethod_0(this, "Email", Delegate216.delegate216_0);
							return;
						}
						return;
					}
					else
					{
						if (Delegate102.smethod_0(text, "NetworkPort", Delegate102.delegate102_0))
						{
							Delegate216.smethod_0(this, "NetworkPort", Delegate216.delegate216_0);
							return;
						}
						return;
					}
				}
				else
				{
					if (Delegate102.smethod_0(text, "Credits", Delegate102.delegate102_0))
					{
						Delegate216.smethod_0(this, "Credits", Delegate216.delegate216_0);
						return;
					}
					return;
				}
			}
			else
			{
				if (num > 2899395429U)
				{
					if (num != 4170810385U)
					{
						if (num == 4198896611U)
						{
							if (Delegate102.smethod_0(text, "ReplikantoID", Delegate102.delegate102_0))
							{
								Delegate216.smethod_0(this, "ReplikantoID", Delegate216.delegate216_0);
								return;
							}
							return;
						}
					}
					else
					{
						if (!Delegate102.smethod_0(text, "WindowTitle", Delegate102.delegate102_0))
						{
							return;
						}
						Delegate216.smethod_0(this, "WindowTitle", Delegate216.delegate216_0);
					}
					return;
				}
				if (num != 2146919026U)
				{
					if (num != 2899395429U)
					{
						return;
					}
					if (!Delegate102.smethod_0(text, "EmailSubject", Delegate102.delegate102_0))
					{
						return;
					}
					Delegate216.smethod_0(this, "EmailSubject", Delegate216.delegate216_0);
					return;
				}
				else
				{
					if (Delegate102.smethod_0(text, "OnlyActiveWokspace", Delegate102.delegate102_0))
					{
						Delegate216.smethod_0(this, "OnlyActiveWokspace", Delegate216.delegate216_0);
						return;
					}
					return;
				}
			}
		}

		public void Fill(ReplikantoProperties newProp)
		{
			if (this.OrderTypeWhenInvert != newProp.OrderTypeWhenInvert)
			{
				this.OrderTypeWhenInvert = newProp.OrderTypeWhenInvert;
			}
			if (this.OffSet != newProp.OffSet)
			{
				this.OffSet = newProp.OffSet;
			}
			if (Delegate104.smethod_0(this.ReplikantoID, newProp.ReplikantoID, Delegate104.delegate104_0))
			{
				this.ReplikantoID = newProp.ReplikantoID;
			}
			if (this.OnlyActiveWokspace != newProp.OnlyActiveWokspace)
			{
				this.OnlyActiveWokspace = newProp.OnlyActiveWokspace;
			}
			if (this.BlockCopy != newProp.BlockCopy)
			{
				this.BlockCopy = newProp.BlockCopy;
			}
			if (this.ScalperTicketIntegration != newProp.ScalperTicketIntegration)
			{
				this.ScalperTicketIntegration = newProp.ScalperTicketIntegration;
			}
			if (this.Credits != newProp.Credits)
			{
				this.Credits = newProp.Credits;
			}
			if (this.CreditAlert != newProp.CreditAlert)
			{
				this.CreditAlert = newProp.CreditAlert;
			}
			if (this.NetworkPort != newProp.NetworkPort)
			{
				this.NetworkPort = newProp.NetworkPort;
			}
			if (this.LocalNetworkTimeout != newProp.LocalNetworkTimeout)
			{
				this.LocalNetworkTimeout = newProp.LocalNetworkTimeout;
			}
			if (this.bool_12 != newProp.bool_12)
			{
				this.bool_12 = newProp.bool_12;
			}
			if (Delegate546.smethod_0(this, Delegate546.delegate546_0) != Delegate279.smethod_0(newProp, Delegate279.delegate279_0))
			{
				Delegate547.smethod_0(this, Delegate279.smethod_0(newProp, Delegate279.delegate279_0), Delegate547.delegate547_0);
			}
			if (this.AreTabsVisible != newProp.AreTabsVisible)
			{
				this.AreTabsVisible = newProp.AreTabsVisible;
			}
			if (Delegate104.smethod_0(this.TabName, newProp.TabName, Delegate104.delegate104_0))
			{
				this.TabName = Delegate548.smethod_0(newProp.TabName, Delegate548.delegate548_0);
			}
			if (this.StealthMode != newProp.StealthMode)
			{
				this.StealthMode = newProp.StealthMode;
			}
			if (Delegate104.smethod_0(this.NetworkAdapterName, newProp.NetworkAdapterName, Delegate104.delegate104_0))
			{
				this.NetworkAdapter = ReplikantoProperties.NetworkAdapterEnumConverter.GetFirst(newProp.NetworkAdapterName);
			}
			if (this.CancelEntrySeconds != newProp.CancelEntrySeconds)
			{
				this.CancelEntrySeconds = newProp.CancelEntrySeconds;
			}
			if (this.FlattenPositionSecondsOnError != newProp.FlattenPositionSecondsOnError)
			{
				this.FlattenPositionSecondsOnError = newProp.FlattenPositionSecondsOnError;
			}
			if (this.CancelEntry != newProp.CancelEntry)
			{
				this.CancelEntry = newProp.CancelEntry;
			}
			if (this.FlattenPositionOnOutOfSync != newProp.FlattenPositionOnOutOfSync)
			{
				this.FlattenPositionOnOutOfSync = newProp.FlattenPositionOnOutOfSync;
			}
			if (this.FlattenPositionOnOutOfSyncSeconds != newProp.FlattenPositionOnOutOfSyncSeconds)
			{
				this.FlattenPositionOnOutOfSyncSeconds = newProp.FlattenPositionOnOutOfSyncSeconds;
			}
			if (this.FlattenPositionOnOppositeDirection != newProp.FlattenPositionOnOppositeDirection)
			{
				this.FlattenPositionOnOppositeDirection = newProp.FlattenPositionOnOppositeDirection;
			}
			if (this.FlattenPositionOnOppositeDirectionSeconds != newProp.FlattenPositionOnOppositeDirectionSeconds)
			{
				this.FlattenPositionOnOppositeDirectionSeconds = newProp.FlattenPositionOnOppositeDirectionSeconds;
			}
			if (this.FlattenPositionOnRejectError != newProp.FlattenPositionOnRejectError)
			{
				this.FlattenPositionOnRejectError = newProp.FlattenPositionOnRejectError;
			}
			if (this.FlattenPositionOnSubmitError != newProp.FlattenPositionOnSubmitError)
			{
				this.FlattenPositionOnSubmitError = newProp.FlattenPositionOnSubmitError;
			}
			if (this.FlattenPositionOnChangeError != newProp.FlattenPositionOnChangeError)
			{
				this.FlattenPositionOnChangeError = newProp.FlattenPositionOnChangeError;
			}
			if (this.FlattenPositionOnCancelError != newProp.FlattenPositionOnCancelError)
			{
				this.FlattenPositionOnCancelError = newProp.FlattenPositionOnCancelError;
			}
			if (this.FlattenPositionOnOtherError != newProp.FlattenPositionOnOtherError)
			{
				this.FlattenPositionOnOtherError = newProp.FlattenPositionOnOtherError;
			}
			if (Delegate104.smethod_0(this.Email, newProp.Email, Delegate104.delegate104_0))
			{
				string email = newProp.Email;
				this.Email = ((email != null) ? Delegate549.smethod_0(email, Delegate549.delegate549_0) : null);
			}
			if (Delegate104.smethod_0(this.EmailSubject, newProp.EmailSubject, Delegate104.delegate104_0))
			{
				string emailSubject = newProp.EmailSubject;
				this.EmailSubject = ((emailSubject == null) ? null : Delegate549.smethod_0(emailSubject, Delegate549.delegate549_0));
			}
			if (this.ConnectionColumn != newProp.ConnectionColumn)
			{
				this.ConnectionColumn = newProp.ConnectionColumn;
			}
			if (this.SideColumn != newProp.SideColumn)
			{
				this.SideColumn = newProp.SideColumn;
			}
			if (this.QuantityColumn != newProp.QuantityColumn)
			{
				this.QuantityColumn = newProp.QuantityColumn;
			}
			if (this.AveragePriceColumn != newProp.AveragePriceColumn)
			{
				this.AveragePriceColumn = newProp.AveragePriceColumn;
			}
			if (this.Boolean_0 != newProp.Boolean_0)
			{
				this.Boolean_0 = newProp.Boolean_0;
			}
			if (this.CashValueColumn != newProp.CashValueColumn)
			{
				this.CashValueColumn = newProp.CashValueColumn;
			}
			if (this.DescriptionNodeColumn != newProp.DescriptionNodeColumn)
			{
				this.DescriptionNodeColumn = newProp.DescriptionNodeColumn;
			}
			if (this.DescriptionInternetNodeColumn != newProp.DescriptionInternetNodeColumn)
			{
				this.DescriptionInternetNodeColumn = newProp.DescriptionInternetNodeColumn;
			}
			if (Delegate104.smethod_0(this.string_5, newProp.string_5, Delegate104.delegate104_0))
			{
				string text = newProp.string_5;
				this.string_5 = ((text == null) ? null : Delegate549.smethod_0(text, Delegate549.delegate549_0));
				Delegate216.smethod_0(this, "LeaderReplikantoID", Delegate216.delegate216_0);
			}
			if (Delegate104.smethod_0(this.string_6, newProp.string_6, Delegate104.delegate104_0))
			{
				string text2 = newProp.string_6;
				this.string_6 = ((text2 != null) ? Delegate549.smethod_0(text2, Delegate549.delegate549_0) : null);
				Delegate216.smethod_0(this, "LeaderAccountName", Delegate216.delegate216_0);
			}
			if (Delegate104.smethod_0(this.WindowTitle, newProp.WindowTitle, Delegate104.delegate104_0))
			{
				string windowTitle = newProp.WindowTitle;
				this.WindowTitle = ((windowTitle == null) ? null : Delegate549.smethod_0(windowTitle, Delegate549.delegate549_0));
			}
			if (this.DisarmFollowers != newProp.DisarmFollowers)
			{
				this.DisarmFollowers = newProp.DisarmFollowers;
				Delegate216.smethod_0(this, "DisarmFollowers", Delegate216.delegate216_0);
			}
		}

		[PropertyEditor("NinjaTrader.Gui.Tools.StringStandardValuesEditorKey")]
		[Display(ResourceType = typeof(Resources), Name = "OrderTypeForNegativeRatio", GroupName = "General", Order = 20)]
		[TypeConverter(typeof(ReplikantoProperties.OrderTypeWhenInvertEnumConverter))]
		[XmlElement(ElementName = "OrderTypeWhenInvert")]
		public OrderType OrderTypeWhenInvert
		{
			get
			{
				return this.orderTypeWhenInvert;
			}
			set
			{
				this.orderTypeWhenInvert = value;
				Delegate216.smethod_0(this, "OrderTypeWhenInvert", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "StopLimitOffsetForStopLimit", GroupName = "General", Order = 30)]
		[XmlElement(ElementName = "OffSet")]
		public uint OffSet
		{
			get
			{
				return this.offSet;
			}
			set
			{
				this.offSet = value;
				Delegate216.smethod_0(this, "OffSet", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "StealthMode", Description = "StealthModeDesc", GroupName = "General", Order = 40)]
		[ReadOnly(false)]
		[XmlElement(ElementName = "StealthMode")]
		public bool StealthMode
		{
			get
			{
				return this.stealthMode;
			}
			set
			{
				this.stealthMode = value;
				Delegate216.smethod_0(this, "StealthMode", Delegate216.delegate216_0);
			}
		}

		[PropertyEditor("NinjaTrader.Gui.Tools.VariableSelectorEditor")]
		[VariableSelectionType(2)]
		[Display(ResourceType = typeof(Resource), Name = "PropertyNameTabName", GroupName = "PropertyCategoryGeneral", Order = 10)]
		public string TabName
		{
			get
			{
				return this.string_0;
			}
			set
			{
				this.string_0 = value;
				Delegate216.smethod_0(this, "TabName", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "OnlyActiveWokspace", GroupName = "General", Order = 50)]
		public bool OnlyActiveWokspace
		{
			get
			{
				return this.bool_0;
			}
			set
			{
				this.bool_0 = value;
				Delegate216.smethod_0(this, "OnlyActiveWokspace", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "BlockCopy", Description = "BlockCopyDesc", GroupName = "General", Order = 60)]
		public bool BlockCopy
		{
			get
			{
				return this.bool_1;
			}
			set
			{
				this.bool_1 = value;
				Delegate216.smethod_0(this, "PreventCopy", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "ScalperTicketIntegration", Description = "ScalperTicketIntegrationDesk", GroupName = "General", Order = 70)]
		public bool ScalperTicketIntegration
		{
			get
			{
				return this.bool_2;
			}
			set
			{
				this.bool_2 = value;
				Delegate216.smethod_0(this, "ScalperTicketIntegration", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "WindowTitle", GroupName = "General", Order = 80)]
		public string WindowTitle
		{
			get
			{
				return this.string_1;
			}
			set
			{
				this.string_1 = value;
				Delegate216.smethod_0(this, "WindowTitle", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "Email", Description = "EmailDesc", GroupName = "FollowerGuard", Order = 1)]
		public string Email
		{
			get
			{
				return ReplikantoProperties.string_2;
			}
			set
			{
				ReplikantoProperties.string_2 = value;
				Delegate216.smethod_0(this, "Email", Delegate216.delegate216_0);
				ReplikantoProperties.smethod_2("Email");
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "EmailSubject", GroupName = "FollowerGuard", Order = 2)]
		public string EmailSubject
		{
			get
			{
				return ReplikantoProperties.string_3;
			}
			set
			{
				ReplikantoProperties.string_3 = value;
				Delegate216.smethod_0(this, "EmailSubject", Delegate216.delegate216_0);
				ReplikantoProperties.smethod_2("EmailSubject");
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "Disarm", Description = "DisarmDesc", GroupName = "FollowerGuard", Order = 4)]
		public bool DisarmFollowers
		{
			get
			{
				return this.bool_3;
			}
			set
			{
				this.bool_3 = value;
				Delegate216.smethod_0(this, "DisarmFollowers", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "CancelEntry", Description = "CancelEntryDesc", GroupName = "FollowerGuard", Order = 5)]
		public bool CancelEntry
		{
			get
			{
				return this.bool_4;
			}
			set
			{
				this.bool_4 = value;
				Delegate216.smethod_0(this, "CancelEntry", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "CancelEntrySeconds", Description = "CancelEntrySecondsDesc", GroupName = "FollowerGuard", Order = 6)]
		public uint CancelEntrySeconds
		{
			get
			{
				return this.uint_0;
			}
			set
			{
				this.uint_0 = value;
				Delegate216.smethod_0(this, "CancelEntrySeconds", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOutOfSync", Description = "FlattenPositionOutOfSyncDesc", GroupName = "FollowerGuard", Order = 7)]
		public bool FlattenPositionOnOutOfSync
		{
			get
			{
				return this.bool_5;
			}
			set
			{
				this.bool_5 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnOutOfSync", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnOutOfSyncSeconds", Description = "FlattenPositionOnOutOfSyncSecondsDesc", GroupName = "FollowerGuard", Order = 8)]
		public uint FlattenPositionOnOutOfSyncSeconds
		{
			get
			{
				return this.uint_1;
			}
			set
			{
				this.uint_1 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnOutOfSyncSeconds", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOppositeDirection", Description = "FlattenPositionOppositeDirectionDesc", GroupName = "FollowerGuard", Order = 9)]
		public bool FlattenPositionOnOppositeDirection
		{
			get
			{
				return this.bool_6;
			}
			set
			{
				this.bool_6 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnOppositeDirection", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOppositeDirectionSeconds", Description = "FlattenPositionOppositeDirectionSecondsDesc", GroupName = "FollowerGuard", Order = 10)]
		public uint FlattenPositionOnOppositeDirectionSeconds
		{
			get
			{
				return this.uint_2;
			}
			set
			{
				this.uint_2 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnOppositeDirectionSeconds", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnRejectError", Description = "FlattenPositionOnRejectErrorDesc", GroupName = "FollowerGuard", Order = 11)]
		public bool FlattenPositionOnRejectError
		{
			get
			{
				return this.bool_7;
			}
			set
			{
				this.bool_7 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnRejectError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnSubmitError", Description = "FlattenPositionOnSubmitErrorDesc", GroupName = "FollowerGuard", Order = 12)]
		public bool FlattenPositionOnSubmitError
		{
			get
			{
				return this.bool_8;
			}
			set
			{
				this.bool_8 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnSubmitError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnChangeError", Description = "FlattenPositionOnChangeErrorDesc", GroupName = "FollowerGuard", Order = 13)]
		public bool FlattenPositionOnChangeError
		{
			get
			{
				return this.bool_9;
			}
			set
			{
				this.bool_9 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnChangeError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnCancelError", Description = "FlattenPositionOnCancelErrorDesc", GroupName = "FollowerGuard", Order = 14)]
		public bool FlattenPositionOnCancelError
		{
			get
			{
				return this.bool_10;
			}
			set
			{
				this.bool_10 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnCancelError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionOnOtherError", Description = "FlattenPositionOnOtherErrorDesc", GroupName = "FollowerGuard", Order = 15)]
		public bool FlattenPositionOnOtherError
		{
			get
			{
				return this.bool_11;
			}
			set
			{
				this.bool_11 = value;
				Delegate216.smethod_0(this, "FlattenPositionOnOtherError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "FlattenPositionSecondsOnError", Description = "FlattenPositionSecondsOnErrorDesc", GroupName = "FollowerGuard", Order = 16)]
		public uint FlattenPositionSecondsOnError
		{
			get
			{
				return this.uint_3;
			}
			set
			{
				this.uint_3 = value;
				Delegate216.smethod_0(this, "FlattenPositionSecondsOnError", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "ReplikantoID", Description = "ReplikantoIDDesc", GroupName = "RemoteReplikantoInfo", Order = 180)]
		[ReadOnly(true)]
		[XmlIgnore]
		public string ReplikantoID
		{
			get
			{
				return ReplikantoProperties.string_4;
			}
			set
			{
				ReplikantoProperties.string_4 = value;
				Delegate216.smethod_0(this, "ReplikantoID", Delegate216.delegate216_0);
				ReplikantoProperties.smethod_2("ReplikantoID");
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "Credits", Description = "CreditsDesc", GroupName = "RemoteReplikantoInfo", Order = 190)]
		[ReadOnly(true)]
		[XmlIgnore]
		public uint Credits
		{
			get
			{
				return ReplikantoProperties.uint_4;
			}
			set
			{
				ReplikantoProperties.uint_4 = value;
				Delegate216.smethod_0(this, "Credits", Delegate216.delegate216_0);
				ReplikantoProperties.smethod_2("Credits");
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "CreditAlert", Description = "CreditAlertDesc", GroupName = "RemoteReplikantoInfo", Order = 100)]
		public uint CreditAlert
		{
			get
			{
				return this.uint_5;
			}
			set
			{
				this.uint_5 = value;
				Delegate216.smethod_0(this, "CreditAlert", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "LeaderReplikantoID", Description = "LeaderReplikantoIDDesc", GroupName = "RemoteLeaderFilterInfo", Order = 10)]
		public string LeaderReplikantoID
		{
			get
			{
				return this.string_5;
			}
			set
			{
				if (Delegate44.smethod_0(value, Delegate44.delegate44_0))
				{
					this.string_5 = null;
				}
				else
				{
					this.string_5 = value;
				}
				Delegate216.smethod_0(this, "LeaderReplikantoID", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "LeaderAccountName", Description = "LeaderAccountNameDesc", GroupName = "RemoteLeaderFilterInfo", Order = 20)]
		public string LeaderAccountName
		{
			get
			{
				return this.string_6;
			}
			set
			{
				if (Delegate44.smethod_0(value, Delegate44.delegate44_0))
				{
					this.string_6 = null;
				}
				else
				{
					this.string_6 = value;
				}
				Delegate216.smethod_0(this, "LeaderAccountName", Delegate216.delegate216_0);
			}
		}

		[PropertyEditor("NinjaTrader.Gui.Tools.StringStandardValuesEditorKey")]
		[Display(ResourceType = typeof(Resources), Name = "NetworkAdapter", Description = "NetworkAdapterDesc", GroupName = "NetworkReplikantoInfo", Order = 140)]
		[TypeConverter(typeof(ReplikantoProperties.NetworkAdapterEnumConverter))]
		[XmlElement(ElementName = "NetworkAdapter")]
		[XmlIgnore]
		public NetworkInterface NetworkAdapter
		{
			get
			{
				return this.networkAdapter;
			}
			set
			{
				this.networkAdapter = value;
				NetworkInterface networkInterface = this.networkAdapter;
				this.NetworkAdapterName = ((networkInterface == null) ? null : Delegate550.smethod_0(networkInterface, Delegate550.delegate550_0));
				Delegate216.smethod_0(this, "NetworkAdapter", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "NetworkPort", Description = "NetworkPortDesc", GroupName = "NetworkReplikantoInfo", Order = 150)]
		[ReadOnly(false)]
		public uint NetworkPort
		{
			get
			{
				return ReplikantoProperties.uint_6;
			}
			set
			{
				ReplikantoProperties.uint_6 = value;
				Delegate216.smethod_0(this, "NetworkPort", Delegate216.delegate216_0);
				ReplikantoProperties.smethod_2("NetworkPort");
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "LocalNetworkTimeout", Description = "LocalNetworkTimeoutDesc", GroupName = "NetworkReplikantoInfo", Order = 160)]
		public uint LocalNetworkTimeout
		{
			get
			{
				return this.uint_7;
			}
			set
			{
				this.uint_7 = value;
				Delegate216.smethod_0(this, "LocalNetworkTimeout", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "IntrumentPropagation", Description = "IntrumentPropagationDesc", GroupName = "NetworkReplikantoInfo", Order = 170)]
		public bool IntrumentPropagation
		{
			get
			{
				return this.bool_12;
			}
			set
			{
				this.bool_12 = value;
				Delegate216.smethod_0(this, "IntrumentPropagation", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resource), Name = "GuiVersion", GroupName = "GuiVersion", Order = 1000)]
		[ReadOnly(true)]
		[XmlIgnore]
		public string Version
		{
			get
			{
				return Delegate86.smethod_0(Delegate48.smethod_0(Delegate47.smethod_0(Delegate248.smethod_0(Delegate248.delegate248_0), Delegate47.delegate47_0), Delegate48.delegate48_0), Delegate86.delegate86_0);
			}
		}

		[Display(ResourceType = typeof(Resource), Name = "GuiShowTabsProperties", GroupName = "PropertyCategoryWindow", Order = 220)]
		[ReadOnly(true)]
		public bool AreTabsVisible { get; set; }

		[Display(ResourceType = typeof(Resources), Name = "Connection", GroupName = "PropertyCategoryColumns", Order = 1)]
		[ReadOnly(false)]
		public bool ConnectionColumn
		{
			get
			{
				return this.bool_14;
			}
			set
			{
				this.bool_14 = value;
				Delegate216.smethod_0(this, "ConnectionColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "Side", GroupName = "PropertyCategoryColumns", Order = 3)]
		[ReadOnly(false)]
		public bool SideColumn
		{
			get
			{
				return this.bool_15;
			}
			set
			{
				this.bool_15 = value;
				Delegate216.smethod_0(this, "SideColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "Quantity", GroupName = "PropertyCategoryColumns", Order = 4)]
		[ReadOnly(false)]
		public bool QuantityColumn
		{
			get
			{
				return this.bool_16;
			}
			set
			{
				this.bool_16 = value;
				Delegate216.smethod_0(this, "QuantityColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "AveragePrice", GroupName = "PropertyCategoryColumns", Order = 5)]
		[ReadOnly(false)]
		public bool AveragePriceColumn
		{
			get
			{
				return this.bool_17;
			}
			set
			{
				this.bool_17 = value;
				Delegate216.smethod_0(this, "AveragePriceColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "PnL", GroupName = "PropertyCategoryColumns", Order = 6)]
		[ReadOnly(false)]
		public bool Boolean_0
		{
			get
			{
				return this.bool_18;
			}
			set
			{
				this.bool_18 = value;
				Delegate216.smethod_0(this, "PnLColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "DescriptionNode", GroupName = "PropertyCategoryColumns", Order = 7)]
		[ReadOnly(false)]
		public bool DescriptionNodeColumn
		{
			get
			{
				return this.bool_19;
			}
			set
			{
				this.bool_19 = value;
				Delegate216.smethod_0(this, "DescriptionNodeColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "DescriptionInternetNode", GroupName = "PropertyCategoryColumns", Order = 8)]
		[ReadOnly(false)]
		public bool DescriptionInternetNodeColumn
		{
			get
			{
				return this.bool_20;
			}
			set
			{
				this.bool_20 = value;
				Delegate216.smethod_0(this, "DescriptionInternetNodeColumn", Delegate216.delegate216_0);
			}
		}

		[Display(ResourceType = typeof(Resources), Name = "CashValue", GroupName = "PropertyCategoryColumns", Order = 9)]
		[ReadOnly(false)]
		public bool CashValueColumn
		{
			get
			{
				return this.bool_21;
			}
			set
			{
				this.bool_21 = value;
				Delegate216.smethod_0(this, "CashValueColumn", Delegate216.delegate216_0);
			}
		}

		internal static void smethod_3()
		{
		}

		internal static void smethod_4()
		{
		}

		internal static void smethod_5(object object_0)
		{
			ReplikantoProperties.smethod_0(object_0);
		}

		internal static object smethod_6(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_7(object object_0, object object_1, object object_2)
		{
			object_0(object_1, object_2);
		}

		internal static uint smethod_8(object object_0)
		{
			return <PrivateImplementationDetails>.ComputeStringHash(object_0);
		}

		internal static OrderType smethod_9(object object_0)
		{
			return object_0.OrderTypeWhenInvert;
		}

		internal static uint smethod_10(object object_0)
		{
			return object_0.OffSet;
		}

		internal static object smethod_11(object object_0)
		{
			return object_0.ReplikantoID;
		}

		internal static bool smethod_12(object object_0)
		{
			return object_0.OnlyActiveWokspace;
		}

		internal static bool smethod_13(object object_0)
		{
			return object_0.BlockCopy;
		}

		internal static bool smethod_14(object object_0)
		{
			return object_0.ScalperTicketIntegration;
		}

		internal static uint smethod_15(object object_0)
		{
			return object_0.Credits;
		}

		internal static uint smethod_16(object object_0)
		{
			return object_0.CreditAlert;
		}

		internal static uint smethod_17(object object_0)
		{
			return object_0.NetworkPort;
		}

		internal static uint smethod_18(object object_0)
		{
			return object_0.LocalNetworkTimeout;
		}

		internal static bool smethod_19(object object_0)
		{
			return object_0.AreTabsVisible;
		}

		internal static object smethod_20(object object_0)
		{
			return object_0.TabName;
		}

		internal static bool smethod_21(object object_0)
		{
			return object_0.StealthMode;
		}

		internal static uint smethod_22(object object_0)
		{
			return object_0.CancelEntrySeconds;
		}

		internal static uint smethod_23(object object_0)
		{
			return object_0.FlattenPositionSecondsOnError;
		}

		internal static bool smethod_24(object object_0)
		{
			return object_0.CancelEntry;
		}

		internal static bool smethod_25(object object_0)
		{
			return object_0.FlattenPositionOnOutOfSync;
		}

		internal static uint smethod_26(object object_0)
		{
			return object_0.FlattenPositionOnOutOfSyncSeconds;
		}

		internal static bool smethod_27(object object_0)
		{
			return object_0.FlattenPositionOnOppositeDirection;
		}

		internal static uint smethod_28(object object_0)
		{
			return object_0.FlattenPositionOnOppositeDirectionSeconds;
		}

		internal static bool smethod_29(object object_0)
		{
			return object_0.FlattenPositionOnRejectError;
		}

		internal static bool smethod_30(object object_0)
		{
			return object_0.FlattenPositionOnSubmitError;
		}

		internal static bool smethod_31(object object_0)
		{
			return object_0.FlattenPositionOnChangeError;
		}

		internal static bool smethod_32(object object_0)
		{
			return object_0.FlattenPositionOnCancelError;
		}

		internal static bool smethod_33(object object_0)
		{
			return object_0.FlattenPositionOnOtherError;
		}

		internal static object smethod_34(object object_0)
		{
			return object_0.Email;
		}

		internal static object smethod_35(object object_0)
		{
			return object_0.EmailSubject;
		}

		internal static bool smethod_36(object object_0)
		{
			return object_0.ConnectionColumn;
		}

		internal static bool smethod_37(object object_0)
		{
			return object_0.SideColumn;
		}

		internal static bool smethod_38(object object_0)
		{
			return object_0.QuantityColumn;
		}

		internal static bool smethod_39(object object_0)
		{
			return object_0.AveragePriceColumn;
		}

		internal static bool smethod_40(object object_0)
		{
			return object_0.Boolean_0;
		}

		internal static bool smethod_41(object object_0)
		{
			return object_0.CashValueColumn;
		}

		internal static bool smethod_42(object object_0)
		{
			return object_0.DescriptionNodeColumn;
		}

		internal static bool smethod_43(object object_0)
		{
			return object_0.DescriptionInternetNodeColumn;
		}

		internal static object smethod_44(object object_0)
		{
			return object_0.WindowTitle;
		}

		internal static bool smethod_45(object object_0)
		{
			return object_0.DisarmFollowers;
		}

		internal static void smethod_46(object object_0)
		{
			ReplikantoProperties.smethod_2(object_0);
		}

		internal static void smethod_47()
		{
		}

		[CompilerGenerated]
		private static PropertyChangedEventHandler htBfnmetgc = new PropertyChangedEventHandler(ReplikantoProperties.<>c.<>c_0.method_0);

		[Browsable(false)]
		[XmlIgnore]
		public OrderType orderTypeWhenInvert;

		[Browsable(false)]
		[XmlIgnore]
		public uint offSet;

		[Browsable(false)]
		[XmlIgnore]
		public bool stealthMode;

		private string string_0;

		private bool bool_0;

		private bool bool_1;

		private bool bool_2;

		private string string_1;

		private static string string_2;

		private static string string_3;

		private bool bool_3;

		private bool bool_4;

		private uint uint_0;

		private bool bool_5;

		private uint uint_1;

		private bool bool_6;

		private uint uint_2;

		private bool bool_7;

		private bool bool_8;

		private bool bool_9;

		private bool bool_10;

		private bool bool_11;

		private uint uint_3;

		private static string string_4;

		private static uint uint_4;

		private uint uint_5;

		private string string_5;

		private string string_6;

		[Browsable(false)]
		[XmlElement(ElementName = "NetworkAdapterName")]
		public string NetworkAdapterName;

		[Browsable(false)]
		[XmlIgnore]
		public NetworkInterface networkAdapter;

		private static uint uint_6;

		private uint uint_7;

		private bool bool_12;

		[CompilerGenerated]
		private bool bool_13;

		private bool bool_14;

		private bool bool_15;

		private bool bool_16;

		private bool bool_17;

		private bool bool_18;

		private bool bool_19;

		private bool bool_20;

		private bool bool_21;

		public class OrderTypeWhenInvertEnumConverter : TypeConverter
		{
			public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
			{
				return new TypeConverter.StandardValuesCollection(new List<string>
				{
					ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_0,
					ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_1
				});
			}

			public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value)
			{
				string text = Delegate86.smethod_0(value, Delegate86.delegate86_0);
				if (Delegate102.smethod_0(text, ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_0, Delegate102.delegate102_0))
				{
					return 4;
				}
				if (Delegate102.smethod_0(text, ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_1, Delegate102.delegate102_0))
				{
					return 3;
				}
				return 4;
			}

			public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType)
			{
				OrderType orderType = (OrderType)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderType).TypeHandle, Delegate45.delegate45_0), Delegate86.smethod_0(value, Delegate86.delegate86_0), Delegate106.delegate106_0);
				if (orderType == 3)
				{
					return ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_1;
				}
				if (orderType == 4)
				{
					return ReplikantoProperties.OrderTypeWhenInvertEnumConverter.string_0;
				}
				return string.Empty;
			}

			public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
			{
				return true;
			}

			public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
			{
				return true;
			}

			public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
			{
				return true;
			}

			public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
			{
				return true;
			}

			internal static void smethod_0()
			{
			}

			internal static void smethod_1()
			{
			}

			internal static void smethod_2()
			{
			}

			private static string string_0 = Delegate690.smethod_0(Delegate690.delegate690_0);

			private static string string_1 = Delegate691.smethod_0(Delegate691.delegate691_0);
		}

		public class NetworkAdapterEnumConverter : TypeConverter
		{
			public static NetworkInterface GetFirst(string name = null)
			{
				try
				{
					foreach (NetworkInterface networkInterface in Delegate692.smethod_0(Delegate692.delegate692_0))
					{
						if (Delegate693.smethod_0(networkInterface, Delegate693.delegate693_0) == OperationalStatus.Up && (Delegate694.smethod_0(networkInterface, Delegate694.delegate694_0) == NetworkInterfaceType.Ethernet || Delegate694.smethod_0(networkInterface, Delegate694.delegate694_0) == NetworkInterfaceType.Wireless80211))
						{
							IEnumerator<UnicastIPAddressInformation> enumerator = Delegate319.smethod_0(Delegate318.smethod_0(Delegate317.smethod_0(networkInterface, Delegate317.delegate317_0), Delegate318.delegate318_0), Delegate319.delegate319_0);
							try
							{
								while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
								{
									if (Delegate321.smethod_0(Delegate320.smethod_0(enumerator.Current, Delegate320.delegate320_0), Delegate321.delegate321_0) == AddressFamily.InterNetwork)
									{
										if (name == null)
										{
											return networkInterface;
										}
										if (Delegate102.smethod_0(name, Delegate550.smethod_0(networkInterface, Delegate550.delegate550_0), Delegate102.delegate102_0))
										{
											return networkInterface;
										}
									}
								}
							}
							finally
							{
								if (enumerator != null)
								{
									Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
								}
							}
						}
					}
				}
				catch (Exception ex)
				{
					Delegate83.smethod_0(Delegate31.smethod_0(ex, Delegate31.delegate31_0), 0, Delegate83.delegate83_0);
				}
				return null;
			}

			public override TypeConverter.StandardValuesCollection GetStandardValues(ITypeDescriptorContext context)
			{
				TypeConverter.StandardValuesCollection standardValuesCollection;
				try
				{
					List<string> list = new List<string>();
					foreach (NetworkInterface networkInterface in Delegate692.smethod_0(Delegate692.delegate692_0))
					{
						if (Delegate693.smethod_0(networkInterface, Delegate693.delegate693_0) == OperationalStatus.Up && (Delegate694.smethod_0(networkInterface, Delegate694.delegate694_0) == NetworkInterfaceType.Ethernet || Delegate694.smethod_0(networkInterface, Delegate694.delegate694_0) == NetworkInterfaceType.Wireless80211))
						{
							IEnumerator<UnicastIPAddressInformation> enumerator = Delegate319.smethod_0(Delegate318.smethod_0(Delegate317.smethod_0(networkInterface, Delegate317.delegate317_0), Delegate318.delegate318_0), Delegate319.delegate319_0);
							try
							{
								while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
								{
									if (Delegate321.smethod_0(Delegate320.smethod_0(enumerator.Current, Delegate320.delegate320_0), Delegate321.delegate321_0) == AddressFamily.InterNetwork)
									{
										list.Add(Delegate550.smethod_0(networkInterface, Delegate550.delegate550_0));
									}
								}
							}
							finally
							{
								if (enumerator != null)
								{
									Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
								}
							}
						}
					}
					standardValuesCollection = new TypeConverter.StandardValuesCollection(list);
				}
				catch (Exception ex)
				{
					Delegate83.smethod_0(Delegate31.smethod_0(ex, Delegate31.delegate31_0), 0, Delegate83.delegate83_0);
					standardValuesCollection = new TypeConverter.StandardValuesCollection(new List<string>());
				}
				return standardValuesCollection;
			}

			public override object ConvertFrom(ITypeDescriptorContext context, CultureInfo culture, object value)
			{
				try
				{
					string text = Delegate86.smethod_0(value, Delegate86.delegate86_0);
					foreach (NetworkInterface networkInterface in Delegate692.smethod_0(Delegate692.delegate692_0))
					{
						if (Delegate300.smethod_0(text, Delegate550.smethod_0(networkInterface, Delegate550.delegate550_0), Delegate300.delegate300_0))
						{
							return networkInterface;
						}
					}
					goto IL_0070;
				}
				catch (Exception ex)
				{
					Delegate83.smethod_0(Delegate31.smethod_0(ex, Delegate31.delegate31_0), 0, Delegate83.delegate83_0);
					goto IL_0070;
				}
				object obj;
				return obj;
				IL_0070:
				return string.Empty;
			}

			public override object ConvertTo(ITypeDescriptorContext context, CultureInfo culture, object value, Type destinationType)
			{
				object obj;
				try
				{
					obj = Delegate550.smethod_0((NetworkInterface)value, Delegate550.delegate550_0);
				}
				catch (Exception ex)
				{
					Delegate83.smethod_0(Delegate31.smethod_0(ex, Delegate31.delegate31_0), 0, Delegate83.delegate83_0);
					obj = string.Empty;
				}
				return obj;
			}

			public override bool CanConvertFrom(ITypeDescriptorContext context, Type sourceType)
			{
				return true;
			}

			public override bool CanConvertTo(ITypeDescriptorContext context, Type destinationType)
			{
				return true;
			}

			public override bool GetStandardValuesExclusive(ITypeDescriptorContext context)
			{
				return true;
			}

			public override bool GetStandardValuesSupported(ITypeDescriptorContext context)
			{
				return true;
			}

			internal static void smethod_0()
			{
			}

			internal static void smethod_1()
			{
			}

			internal static void smethod_2()
			{
			}
		}
	}
}
