﻿using System;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;
using Newtonsoft.Json;
using NinjaTrader.Cbi;

namespace Replikanto
{
	public class ReplikantoPosition
	{
		[JsonProperty(PropertyName = "quantity")]
		public int Quantity { get; set; }

		[JsonProperty(PropertyName = "averagePrice")]
		public double AveragePrice { get; set; }

		[JsonProperty(PropertyName = "marketPosition")]
		public MarketPosition MarketPosition { get; set; }

		internal static ReplikantoPosition Create(Position position)
		{
			if (position != null)
			{
				return new ReplikantoPosition
				{
					Quantity = Delegate193.smethod_0(position, Delegate193.delegate193_0),
					AveragePrice = Delegate194.smethod_0(position, Delegate194.delegate194_0),
					MarketPosition = Delegate195.smethod_0(position, Delegate195.delegate195_0)
				};
			}
			return null;
		}

		public override string ToString()
		{
			PropertyInfo[] array = Delegate166.smethod_0(Delegate165.smethod_0(this, Delegate165.delegate165_0), Delegate166.delegate166_0);
			StringBuilder stringBuilder = new StringBuilder();
			foreach (PropertyInfo propertyInfo in array)
			{
				try
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate169.smethod_0(propertyInfo, this, Delegate169.delegate169_0), Delegate170.delegate170_0);
				}
				catch (TargetInvocationException)
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "null", Delegate170.delegate170_0);
				}
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		internal static void smethod_0(object object_0, int value)
		{
			object_0.Quantity = value;
		}

		internal static void smethod_1(object object_0, double value)
		{
			object_0.AveragePrice = value;
		}

		internal static void smethod_2(object object_0, MarketPosition value)
		{
			object_0.MarketPosition = value;
		}

		internal static object smethod_3(int int_1)
		{
			return Class10.smethod_17(int_1);
		}

		internal static void smethod_4()
		{
		}

		internal static void smethod_5()
		{
		}

		[CompilerGenerated]
		private int int_0;

		[CompilerGenerated]
		private double double_0;

		[CompilerGenerated]
		private MarketPosition marketPosition_0;
	}
}
