﻿using System;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;
using Newtonsoft.Json;
using NinjaTrader.Cbi;

namespace Replikanto
{
	internal class ReplikantoOrderEventArgs : OrderEventArgs
	{
		[JsonProperty(PropertyName = "averageFillPrice")]
		public double AverageFillPrice { get; set; }

		[JsonProperty(PropertyName = "comment")]
		public string Comment { get; set; }

		[JsonProperty(PropertyName = "error")]
		public ErrorCode Error { get; set; }

		[JsonProperty(PropertyName = "filled")]
		public int Filled { get; set; }

		[JsonProperty(PropertyName = "limitPrice")]
		public double LimitPrice { get; set; }

		[JsonProperty(PropertyName = "orderState")]
		public string OrderStateName { get; set; }

		public OrderState OrderState
		{
			get
			{
				OrderState orderState;
				try
				{
					orderState = (OrderState)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderState).TypeHandle, Delegate45.delegate45_0), this.OrderStateName, Delegate106.delegate106_0);
				}
				catch
				{
					orderState = 99;
				}
				return orderState;
			}
		}

		[JsonProperty(PropertyName = "stopPrice")]
		public double StopPrice { get; set; }

		[JsonProperty(PropertyName = "quantity")]
		public int Quantity { get; set; }

		[JsonProperty(PropertyName = "time")]
		public DateTime Time { get; set; }

		public override string ToString()
		{
			PropertyInfo[] array = Delegate166.smethod_0(Delegate165.smethod_0(this, Delegate165.delegate165_0), Delegate166.delegate166_0);
			StringBuilder stringBuilder = new StringBuilder();
			foreach (PropertyInfo propertyInfo in array)
			{
				try
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate169.smethod_0(propertyInfo, this, Delegate169.delegate169_0), Delegate170.delegate170_0);
				}
				catch (TargetInvocationException)
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "null", Delegate170.delegate170_0);
				}
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		internal static object smethod_0(int int_2)
		{
			return Class10.smethod_17(int_2);
		}

		internal static void smethod_1()
		{
		}

		internal static void smethod_2()
		{
		}

		internal static void smethod_3()
		{
		}

		[CompilerGenerated]
		private double double_0;

		[CompilerGenerated]
		private string string_0;

		[CompilerGenerated]
		private ErrorCode errorCode_0;

		[CompilerGenerated]
		private int int_0;

		[CompilerGenerated]
		private double double_1;

		[CompilerGenerated]
		private string string_1;

		[CompilerGenerated]
		private double double_2;

		[CompilerGenerated]
		private int int_1;

		[CompilerGenerated]
		private DateTime dateTime_0;
	}
}
