﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;
using Newtonsoft.Json;
using NinjaTrader.Cbi;
using NinjaTrader.Core;
using NinjaTrader.NinjaScript;
using NinjaTrader.Tradovate;
using Replikanto.Util;

namespace Replikanto
{
	internal class ReplikantoOrder : IEquatable<ReplikantoOrder>
	{
		[JsonProperty(PropertyName = "id")]
		public string Id { get; set; }

		[JsonIgnore]
		public long OriginalId
		{
			get
			{
				if (this.long_0 >= 0L)
				{
					return this.long_0;
				}
				long num;
				try
				{
					if (this.IsFromExecution)
					{
						num = (this.long_0 = Delegate98.smethod_0(Delegate97.smethod_0(this.Id, "_", string.Empty, Delegate97.delegate97_0), Delegate98.delegate98_0));
						num = num;
					}
					else
					{
						num = (this.long_0 = Delegate98.smethod_0(this.Id, Delegate98.delegate98_0));
					}
				}
				catch
				{
					try
					{
						string text = new string(this.Id.Where(new Func<char, bool>(char.IsDigit)).ToArray<char>());
						num = (this.long_0 = Delegate98.smethod_0(Delegate101.smethod_0(text, 0, Delegate100.smethod_0(18, Delegate99.smethod_0(text, Delegate99.delegate99_0), Delegate100.delegate100_0), Delegate101.delegate101_0), Delegate98.delegate98_0));
					}
					catch
					{
						Delegate34.smethod_0(Delegate51.smethod_0("Replikanto: Order ", this.Id, " has no OriginalId", Delegate51.delegate51_0), 3, Delegate34.delegate34_0);
						num = 0L;
					}
				}
				return num;
			}
		}

		[JsonProperty(PropertyName = "orderId")]
		public string OrderId { get; set; }

		[JsonProperty(PropertyName = "initialEntryOrder")]
		public long InitialEntryOrder { get; set; }

		[JsonProperty(PropertyName = "name")]
		public string Name
		{
			get
			{
				return this.string_2;
			}
			set
			{
				this.string_2 = value;
				try
				{
					if (Delegate102.smethod_0(this.string_2, "Close", Delegate102.delegate102_0) && Delegate104.smethod_0(Delegate103.smethod_0(Delegate103.delegate103_0), "Close", Delegate104.delegate104_0))
					{
						this.string_2 = Delegate103.smethod_0(Delegate103.delegate103_0);
					}
				}
				catch
				{
				}
			}
		}

		[JsonProperty(PropertyName = "oco")]
		public string Oco { get; set; }

		[JsonProperty(PropertyName = "instrument")]
		public string InstrumentFullName { get; set; }

		[JsonProperty(PropertyName = "orderAction")]
		public string OrderActionName { get; set; }

		[JsonProperty(PropertyName = "orderEntry")]
		public string OrderEntryName { get; set; }

		[JsonProperty(PropertyName = "orderType")]
		public string OrderTypeName { get; set; }

		[JsonProperty(PropertyName = "tif")]
		public string TifName { get; set; }

		[JsonProperty(PropertyName = "limitPrice")]
		public double LimitPrice { get; set; }

		[JsonProperty(PropertyName = "stopPrice")]
		public double StopPrice { get; set; }

		[JsonProperty(PropertyName = "quantity")]
		public int Quantity { get; set; }

		[JsonProperty(PropertyName = "filled")]
		public int Filled { get; set; }

		[JsonProperty(PropertyName = "orderState")]
		public string OrderStateName { get; set; }

		[JsonProperty(PropertyName = "strategyName")]
		public string StrategyName { get; set; }

		[JsonProperty(PropertyName = "strategyId")]
		public long StrategyId { get; set; }

		[JsonProperty(PropertyName = "strategyOrderIndex")]
		public int StrategyOrderIndex { get; set; }

		[JsonProperty(PropertyName = "strategyOrders")]
		public string StrategyOrders { get; set; }

		[JsonIgnore]
		public StrategyBase StrategyBase { get; set; }

		[JsonProperty(PropertyName = "webStrategyId")]
		public long WebStrategyId
		{
			internal get
			{
				try
				{
					if (this.long_2 == -1L)
					{
						this.long_2 = this.method_0();
					}
				}
				catch
				{
					this.long_2 = 0L;
				}
				return this.long_2;
			}
			set
			{
				this.long_2 = value;
			}
		}

		[JsonProperty(PropertyName = "webStrategyOrderIndex")]
		public int WebStrategyOrderIndex { get; set; } = -1;

		[JsonProperty(PropertyName = "gtd")]
		public DateTime Gtd { get; set; }

		[JsonProperty(PropertyName = "statementDate")]
		public DateTime StatementDate { get; set; }

		[JsonProperty(PropertyName = "time")]
		public DateTime Time { get; set; }

		[JsonIgnore]
		public Account Account { get; private set; }

		[JsonProperty(PropertyName = "account")]
		public ReplikantoAccount ReplikantoAccount { get; set; }

		[JsonProperty(PropertyName = "orderUpdates")]
		public List<ReplikantoOrderEventArgs> OrderUpdates { get; private set; } = new List<ReplikantoOrderEventArgs>();

		[JsonProperty(PropertyName = "scalperTicketOrderType")]
		public ScalperTicketOrderType ScalperTicketOrderType { get; set; }

		[JsonIgnore]
		public Instrument Instrument
		{
			get
			{
				Instrument instrument;
				try
				{
					instrument = Delegate105.smethod_0(this.InstrumentFullName, false, Delegate105.delegate105_0);
				}
				catch (Exception ex)
				{
					Delegate34.smethod_0(Delegate82.smethod_0("Replikanto: Error getting Instrument {0}. {1}", this.InstrumentFullName, ex, Delegate82.delegate82_0), 3, Delegate34.delegate34_0);
					instrument = null;
				}
				return instrument;
			}
		}

		[JsonIgnore]
		public OrderAction OrderAction
		{
			get
			{
				return (OrderAction)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderAction).TypeHandle, Delegate45.delegate45_0), this.OrderActionName, Delegate106.delegate106_0);
			}
		}

		[JsonIgnore]
		public OrderType OrderType
		{
			get
			{
				return (OrderType)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderType).TypeHandle, Delegate45.delegate45_0), this.OrderTypeName, Delegate106.delegate106_0);
			}
		}

		[JsonIgnore]
		public OrderState OrderState
		{
			get
			{
				OrderState orderState;
				try
				{
					orderState = (OrderState)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderState).TypeHandle, Delegate45.delegate45_0), this.OrderStateName, Delegate106.delegate106_0);
				}
				catch
				{
					orderState = 99;
				}
				return orderState;
			}
		}

		[JsonIgnore]
		public OrderEntry OrderEntry
		{
			get
			{
				return (OrderEntry)Delegate106.smethod_0(Delegate45.smethod_0(typeof(OrderEntry).TypeHandle, Delegate45.delegate45_0), this.OrderEntryName, Delegate106.delegate106_0);
			}
		}

		[JsonIgnore]
		public TimeInForce TimeInForce
		{
			get
			{
				return (TimeInForce)Delegate106.smethod_0(Delegate45.smethod_0(typeof(TimeInForce).TypeHandle, Delegate45.delegate45_0), this.TifName, Delegate106.delegate106_0);
			}
		}

		[JsonProperty(PropertyName = "ordersPreviouslySent")]
		public List<ReplikantoOrder> OrdersPreviouslySent { get; set; } = new List<ReplikantoOrder>();

		[JsonProperty(PropertyName = "opositeFilled")]
		public bool HasOpositeFilled { get; internal set; }

		[JsonProperty(PropertyName = "suppressCancel")]
		public bool SuppressCancel { get; internal set; }

		[JsonProperty(PropertyName = "suppressChange")]
		public bool SuppressChange { get; internal set; }

		[JsonProperty(PropertyName = "blockCopy")]
		internal bool BlockCopy { get; set; }

		[JsonIgnore]
		public bool IsStopLimit
		{
			get
			{
				return this.OrderType == 3;
			}
		}

		[JsonIgnore]
		public bool IsStopMarket
		{
			get
			{
				return this.OrderType == 4;
			}
		}

		[JsonProperty(PropertyName = "isSimulatedStop")]
		public bool IsSimulatedStop { get; set; }

		[JsonIgnore]
		public bool IsLimit
		{
			get
			{
				return this.OrderType == 0;
			}
		}

		[JsonProperty(PropertyName = "isEntry")]
		public bool IsEntry { get; set; }

		[JsonProperty(PropertyName = "isFromExecution")]
		public bool IsFromExecution { get; set; }

		[JsonProperty(PropertyName = "isLastExit")]
		public bool IsLastExit { get; set; }

		[JsonProperty(PropertyName = "executionQuantity")]
		public int ExecutionQuantity { get; set; }

		[JsonProperty(PropertyName = "leaderPosition")]
		public ReplikantoPosition LeaderPosition { get; set; }

		public static ReplikantoOrder Parse(Execution e)
		{
			ReplikantoOrder.<>c__DisplayClass181_0 CS$<>8__locals1 = new ReplikantoOrder.<>c__DisplayClass181_0();
			CS$<>8__locals1.execution_0 = e;
			Order order = Delegate107.smethod_0(CS$<>8__locals1.execution_0, Delegate107.delegate107_0);
			if (order == null)
			{
				return null;
			}
			string text = "0";
			long num;
			try
			{
				num = Delegate108.smethod_0(CS$<>8__locals1.execution_0, Delegate108.delegate108_0) % 1000L;
				text = Delegate110.smethod_0(Delegate109.smethod_0(ref num, Delegate109.delegate109_0), 3, '0', Delegate110.delegate110_0);
			}
			catch
			{
			}
			int? num2 = Delegate112.smethod_0(Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0), Delegate112.delegate112_0).ToList<Execution>().Where(new Func<Execution, bool>(CS$<>8__locals1.method_0))
				.Sum(new Func<Execution, int?>(ReplikantoOrder.<>c.<>c_0.method_0));
			Order order2 = Delegate107.smethod_0(CS$<>8__locals1.execution_0, Delegate107.delegate107_0);
			int? num3 = ((order2 == null) ? null : new int?(Delegate113.smethod_0(order2, Delegate113.delegate113_0)));
			bool flag = (num2.GetValueOrDefault() == num3.GetValueOrDefault()) & (num2 != null == (num3 != null));
			ReplikantoOrder replikantoOrder = new ReplikantoOrder();
			num = Delegate114.smethod_0(order, Delegate114.delegate114_0);
			replikantoOrder.Id = Delegate51.smethod_0(Delegate109.smethod_0(ref num, Delegate109.delegate109_0), "_", text, Delegate51.delegate51_0);
			replikantoOrder.OrderId = Delegate51.smethod_0(Delegate115.smethod_0(CS$<>8__locals1.execution_0, Delegate115.delegate115_0), "_", text, Delegate51.delegate51_0);
			replikantoOrder.Name = Delegate116.smethod_0(order, Delegate116.delegate116_0);
			replikantoOrder.Oco = string.Empty;
			replikantoOrder.Time = Delegate117.smethod_0(CS$<>8__locals1.execution_0, Delegate117.delegate117_0);
			replikantoOrder.StatementDate = Delegate118.smethod_0(CS$<>8__locals1.execution_0, Delegate118.delegate118_0);
			Instrument instrument = Delegate119.smethod_0(CS$<>8__locals1.execution_0, Delegate119.delegate119_0);
			replikantoOrder.InstrumentFullName = ((instrument != null) ? Delegate120.smethod_0(instrument, Delegate120.delegate120_0) : null);
			replikantoOrder.OrderActionName = Delegate121.smethod_0(order, Delegate121.delegate121_0).ToString();
			replikantoOrder.OrderEntryName = Delegate122.smethod_0(order, Delegate122.delegate122_0).ToString();
			replikantoOrder.OrderStateName = ((!flag) ? 4.ToString() : 2.ToString());
			replikantoOrder.OrderTypeName = 1.ToString();
			replikantoOrder.Quantity = Delegate123.smethod_0(order, Delegate123.delegate123_0);
			replikantoOrder.Filled = Delegate124.smethod_0(order, Delegate124.delegate124_0);
			replikantoOrder.TifName = 0.ToString();
			replikantoOrder.Account = Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0);
			ReplikantoAccount replikantoAccount = new ReplikantoAccount();
			Account account = Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0);
			replikantoAccount.AccountName = ((account == null) ? null : Delegate125.smethod_0(account, Delegate125.delegate125_0));
			Account account2 = Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0);
			replikantoAccount.DisplayName = ((account2 == null) ? null : Delegate126.smethod_0(account2, Delegate126.delegate126_0));
			Account account3 = Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0);
			replikantoAccount.ProviderName = ((account3 == null) ? null : Delegate127.smethod_0(account3, Delegate127.delegate127_0).ToString());
			replikantoOrder.ReplikantoAccount = replikantoAccount;
			replikantoOrder.IsSimulatedStop = false;
			replikantoOrder.IsFromExecution = true;
			replikantoOrder.IsLastExit = Delegate128.smethod_0(CS$<>8__locals1.execution_0, Delegate128.delegate128_0);
			replikantoOrder.IsEntry = Delegate129.smethod_0(CS$<>8__locals1.execution_0, Delegate129.delegate129_0);
			replikantoOrder.ExecutionQuantity = Delegate130.smethod_0(CS$<>8__locals1.execution_0, Delegate130.delegate130_0);
			ReplikantoOrder replikantoOrder2 = replikantoOrder;
			long originalId = replikantoOrder2.OriginalId;
			try
			{
				Account account4 = Delegate111.smethod_0(CS$<>8__locals1.execution_0, Delegate111.delegate111_0);
				Position position;
				if (account4 == null)
				{
					position = null;
				}
				else
				{
					Instrument instrument2 = Delegate119.smethod_0(CS$<>8__locals1.execution_0, Delegate119.delegate119_0);
					position = Delegate132.smethod_0(account4, ((instrument2 == null) ? null : new long?(Delegate131.smethod_0(instrument2, Delegate131.delegate131_0))).Value, Delegate132.delegate132_0);
				}
				Position position2 = position;
				replikantoOrder2.LeaderPosition = ReplikantoPosition.Create(position2);
			}
			catch
			{
			}
			return replikantoOrder2;
		}

		public static ReplikantoOrder Parse(Order o)
		{
			StrategyBase strategyBase = null;
			string text = string.Empty;
			int num = -1;
			string text2 = string.Empty;
			long num2 = 0L;
			long num3 = 0L;
			if (Delegate133.smethod_0(o, Delegate133.delegate133_0) != null && Delegate133.smethod_0(o, Delegate133.delegate133_0) is AtmStrategy)
			{
				strategyBase = Delegate133.smethod_0(o, Delegate133.delegate133_0);
				num2 = Delegate134.smethod_0(strategyBase, Delegate134.GlcscZpym0);
				text = Delegate135.smethod_0(strategyBase, Delegate135.delegate135_0);
				List<Order> list = new List<Order>();
				try
				{
					list = Delegate136.smethod_0(strategyBase as AtmStrategy, Delegate136.delegate136_0).ToList<Order>().Where(new Func<Order, bool>(ReplikantoOrder.<>c.<>c_0.method_1))
						.ToList<Order>();
				}
				catch (Exception ex)
				{
					Delegate83.smethod_0(Delegate82.smethod_0("ReplikantoOrder - Parse - AtmStrategy - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), ex, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
				}
				num = list.IndexOf(o);
				text2 = Delegate51.smethod_0("[", Delegate49.smethod_0(", ", list.Select(new Func<Order, string>(ReplikantoOrder.<>c.<>c_0.method_2)), Delegate49.delegate49_0), "]", Delegate51.delegate51_0);
				num3 = Delegate114.smethod_0(Delegate137.smethod_0(strategyBase as AtmStrategy, Delegate137.delegate137_0), Delegate114.delegate114_0);
			}
			ReplikantoOrder replikantoOrder = new ReplikantoOrder();
			long num4 = Delegate114.smethod_0(o, Delegate114.delegate114_0);
			replikantoOrder.Id = Delegate109.smethod_0(ref num4, Delegate109.delegate109_0);
			replikantoOrder.OrderId = Delegate138.smethod_0(o, Delegate138.mDysTjiIyF);
			replikantoOrder.Name = Delegate116.smethod_0(o, Delegate116.delegate116_0);
			replikantoOrder.Oco = Delegate139.smethod_0(o, Delegate139.qvGsqSkhle);
			replikantoOrder.Gtd = Delegate140.smethod_0(o, Delegate140.delegate140_0);
			replikantoOrder.Time = Delegate141.smethod_0(o, Delegate141.delegate141_0);
			replikantoOrder.StatementDate = Delegate142.smethod_0(o, Delegate142.rfwsufyocb);
			replikantoOrder.StrategyBase = strategyBase;
			replikantoOrder.StrategyName = text;
			replikantoOrder.StrategyId = num2;
			replikantoOrder.StrategyOrderIndex = num;
			replikantoOrder.StrategyOrders = text2;
			replikantoOrder.InitialEntryOrder = num3;
			Instrument instrument = Delegate143.smethod_0(o, Delegate143.delegate143_0);
			replikantoOrder.InstrumentFullName = ((instrument == null) ? null : Delegate120.smethod_0(instrument, Delegate120.delegate120_0));
			replikantoOrder.LimitPrice = Delegate144.smethod_0(o, Delegate144.delegate144_0);
			replikantoOrder.OrderActionName = Delegate121.smethod_0(o, Delegate121.delegate121_0).ToString();
			replikantoOrder.OrderEntryName = Delegate122.smethod_0(o, Delegate122.delegate122_0).ToString();
			replikantoOrder.OrderStateName = Delegate145.smethod_0(o, Delegate145.delegate145_0).ToString();
			replikantoOrder.OrderTypeName = Delegate146.smethod_0(o, Delegate146.delegate146_0).ToString();
			replikantoOrder.Quantity = Delegate123.smethod_0(o, Delegate123.delegate123_0);
			replikantoOrder.Filled = Delegate124.smethod_0(o, Delegate124.delegate124_0);
			replikantoOrder.StopPrice = Delegate147.smethod_0(o, Delegate147.kBvszTivj9);
			replikantoOrder.TifName = Delegate148.smethod_0(o, Delegate148.delegate148_0).ToString();
			replikantoOrder.Account = Delegate149.smethod_0(o, Delegate149.delegate149_0);
			replikantoOrder.ScalperTicketOrderType = ReplikantoWindow.GetScalperTicketOrderType(Delegate114.smethod_0(o, Delegate114.delegate114_0));
			ReplikantoAccount replikantoAccount = new ReplikantoAccount();
			Account account = Delegate149.smethod_0(o, Delegate149.delegate149_0);
			replikantoAccount.AccountName = ((account == null) ? null : Delegate125.smethod_0(account, Delegate125.delegate125_0));
			Account account2 = Delegate149.smethod_0(o, Delegate149.delegate149_0);
			replikantoAccount.DisplayName = ((account2 == null) ? null : Delegate126.smethod_0(account2, Delegate126.delegate126_0));
			Account account3 = Delegate149.smethod_0(o, Delegate149.delegate149_0);
			replikantoAccount.ProviderName = ((account3 == null) ? null : Delegate127.smethod_0(account3, Delegate127.delegate127_0).ToString());
			replikantoOrder.ReplikantoAccount = replikantoAccount;
			CustomOrder customOrder = Delegate150.smethod_0(o, Delegate150.delegate150_0);
			replikantoOrder.IsSimulatedStop = customOrder != null && Delegate151.smethod_0(customOrder, Delegate151.delegate151_0);
			replikantoOrder.IsEntry = ReplikantoOrder.smethod_1(o);
			ReplikantoOrder replikantoOrder2 = replikantoOrder;
			long originalId = replikantoOrder2.OriginalId;
			try
			{
				ReplikantoOrder replikantoOrder3 = replikantoOrder2;
				IList<OrderEventArgs> list2 = Delegate152.smethod_0(o, Delegate152.delegate152_0);
				replikantoOrder3.OrderUpdates = ((list2 != null) ? list2.ToList<OrderEventArgs>().Cast<ReplikantoOrderEventArgs>().Reverse<ReplikantoOrderEventArgs>()
					.ToList<ReplikantoOrderEventArgs>() : null);
			}
			catch (InvalidCastException)
			{
				IList<OrderEventArgs> list3 = Delegate152.smethod_0(o, Delegate152.delegate152_0);
				List<OrderEventArgs> list4 = ((list3 != null) ? list3.ToList<OrderEventArgs>() : null);
				if (list4 != null)
				{
					list4.Reverse();
				}
				foreach (OrderEventArgs orderEventArgs in list4)
				{
					List<ReplikantoOrderEventArgs> orderUpdates = replikantoOrder2.OrderUpdates;
					if (orderUpdates != null)
					{
						orderUpdates.Add(new ReplikantoOrderEventArgs
						{
							AverageFillPrice = Delegate153.smethod_0(orderEventArgs, Delegate153.delegate153_0),
							Comment = Delegate154.smethod_0(orderEventArgs, Delegate154.delegate154_0),
							Error = Delegate155.smethod_0(orderEventArgs, Delegate155.delegate155_0),
							Filled = Delegate156.smethod_0(orderEventArgs, Delegate156.delegate156_0),
							LimitPrice = Delegate157.smethod_0(orderEventArgs, Delegate157.delegate157_0),
							OrderStateName = Delegate158.smethod_0(orderEventArgs, Delegate158.YneVagLmKx).ToString(),
							StopPrice = Delegate159.smethod_0(orderEventArgs, Delegate159.delegate159_0),
							Time = Delegate160.smethod_0(orderEventArgs, Delegate160.delegate160_0),
							Quantity = Delegate161.smethod_0(orderEventArgs, Delegate161.delegate161_0)
						});
					}
				}
			}
			try
			{
				Account account4 = Delegate149.smethod_0(o, Delegate149.delegate149_0);
				Position position;
				if (account4 != null)
				{
					Instrument instrument2 = Delegate143.smethod_0(o, Delegate143.delegate143_0);
					position = Delegate132.smethod_0(account4, ((instrument2 == null) ? null : new long?(Delegate131.smethod_0(instrument2, Delegate131.delegate131_0))).Value, Delegate132.delegate132_0);
				}
				else
				{
					position = null;
				}
				Position position2 = position;
				replikantoOrder2.LeaderPosition = ReplikantoPosition.Create(position2);
			}
			catch
			{
			}
			return replikantoOrder2;
		}

		public static ReplikantoOrder Parse(OrderEventArgs e)
		{
			Order order = Delegate162.smethod_0(e, Delegate162.delegate162_0);
			StrategyBase strategyBase = null;
			string text = string.Empty;
			int num = -1;
			string text2 = string.Empty;
			long num2 = 0L;
			long num3 = 0L;
			if (Delegate133.smethod_0(order, Delegate133.delegate133_0) != null && Delegate133.smethod_0(order, Delegate133.delegate133_0) is AtmStrategy)
			{
				strategyBase = Delegate133.smethod_0(order, Delegate133.delegate133_0);
				num2 = Delegate134.smethod_0(strategyBase, Delegate134.GlcscZpym0);
				text = Delegate135.smethod_0(strategyBase, Delegate135.delegate135_0);
				List<Order> list = Delegate136.smethod_0(strategyBase as AtmStrategy, Delegate136.delegate136_0).ToList<Order>().Where(new Func<Order, bool>(ReplikantoOrder.<>c.<>c_0.method_3))
					.ToList<Order>();
				num = list.IndexOf(order);
				text2 = Delegate51.smethod_0("[", Delegate49.smethod_0(", ", list.Select(new Func<Order, string>(ReplikantoOrder.<>c.<>c_0.method_4)), Delegate49.delegate49_0), "]", Delegate51.delegate51_0);
				num3 = Delegate114.smethod_0(Delegate137.smethod_0(strategyBase as AtmStrategy, Delegate137.delegate137_0), Delegate114.delegate114_0);
			}
			ReplikantoOrder replikantoOrder = new ReplikantoOrder();
			long num4 = Delegate114.smethod_0(order, Delegate114.delegate114_0);
			replikantoOrder.Id = Delegate109.smethod_0(ref num4, Delegate109.delegate109_0);
			replikantoOrder.OrderId = Delegate163.smethod_0(e, Delegate163.delegate163_0);
			replikantoOrder.Name = Delegate116.smethod_0(order, Delegate116.delegate116_0);
			replikantoOrder.Oco = Delegate139.smethod_0(order, Delegate139.qvGsqSkhle);
			replikantoOrder.Gtd = Delegate140.smethod_0(order, Delegate140.delegate140_0);
			replikantoOrder.Time = Delegate160.smethod_0(e, Delegate160.delegate160_0);
			replikantoOrder.StatementDate = Delegate164.smethod_0(e, Delegate164.delegate164_0);
			replikantoOrder.StrategyBase = strategyBase;
			replikantoOrder.StrategyName = text;
			replikantoOrder.StrategyId = num2;
			replikantoOrder.StrategyOrderIndex = num;
			replikantoOrder.StrategyOrders = text2;
			replikantoOrder.InitialEntryOrder = num3;
			Instrument instrument = Delegate143.smethod_0(order, Delegate143.delegate143_0);
			replikantoOrder.InstrumentFullName = ((instrument == null) ? null : Delegate120.smethod_0(instrument, Delegate120.delegate120_0));
			replikantoOrder.LimitPrice = Delegate157.smethod_0(e, Delegate157.delegate157_0);
			replikantoOrder.OrderActionName = Delegate121.smethod_0(order, Delegate121.delegate121_0).ToString();
			replikantoOrder.OrderEntryName = Delegate122.smethod_0(order, Delegate122.delegate122_0).ToString();
			replikantoOrder.OrderStateName = Delegate158.smethod_0(e, Delegate158.YneVagLmKx).ToString();
			replikantoOrder.OrderTypeName = Delegate146.smethod_0(order, Delegate146.delegate146_0).ToString();
			replikantoOrder.Quantity = Delegate161.smethod_0(e, Delegate161.delegate161_0);
			replikantoOrder.Filled = Delegate156.smethod_0(e, Delegate156.delegate156_0);
			replikantoOrder.StopPrice = Delegate159.smethod_0(e, Delegate159.delegate159_0);
			replikantoOrder.TifName = Delegate148.smethod_0(order, Delegate148.delegate148_0).ToString();
			replikantoOrder.Account = Delegate149.smethod_0(order, Delegate149.delegate149_0);
			replikantoOrder.ScalperTicketOrderType = ReplikantoWindow.GetScalperTicketOrderType(Delegate114.smethod_0(order, Delegate114.delegate114_0));
			ReplikantoAccount replikantoAccount = new ReplikantoAccount();
			Account account = Delegate149.smethod_0(order, Delegate149.delegate149_0);
			replikantoAccount.AccountName = ((account == null) ? null : Delegate125.smethod_0(account, Delegate125.delegate125_0));
			Account account2 = Delegate149.smethod_0(order, Delegate149.delegate149_0);
			replikantoAccount.DisplayName = ((account2 == null) ? null : Delegate126.smethod_0(account2, Delegate126.delegate126_0));
			Account account3 = Delegate149.smethod_0(order, Delegate149.delegate149_0);
			replikantoAccount.ProviderName = ((account3 == null) ? null : Delegate127.smethod_0(account3, Delegate127.delegate127_0).ToString());
			replikantoOrder.ReplikantoAccount = replikantoAccount;
			CustomOrder customOrder = Delegate150.smethod_0(order, Delegate150.delegate150_0);
			replikantoOrder.IsSimulatedStop = customOrder != null && Delegate151.smethod_0(customOrder, Delegate151.delegate151_0);
			replikantoOrder.IsEntry = ReplikantoOrder.smethod_1(order);
			ReplikantoOrder replikantoOrder2 = replikantoOrder;
			long originalId = replikantoOrder2.OriginalId;
			try
			{
				ReplikantoOrder replikantoOrder3 = replikantoOrder2;
				IList<OrderEventArgs> list2 = Delegate152.smethod_0(order, Delegate152.delegate152_0);
				replikantoOrder3.OrderUpdates = ((list2 != null) ? list2.ToList<OrderEventArgs>().Cast<ReplikantoOrderEventArgs>().Reverse<ReplikantoOrderEventArgs>()
					.ToList<ReplikantoOrderEventArgs>() : null);
			}
			catch (InvalidCastException)
			{
				IList<OrderEventArgs> list3 = Delegate152.smethod_0(order, Delegate152.delegate152_0);
				List<OrderEventArgs> list4 = ((list3 != null) ? list3.ToList<OrderEventArgs>() : null);
				if (list4 != null)
				{
					list4.Reverse();
				}
				foreach (OrderEventArgs orderEventArgs in list4)
				{
					List<ReplikantoOrderEventArgs> orderUpdates = replikantoOrder2.OrderUpdates;
					if (orderUpdates != null)
					{
						orderUpdates.Add(new ReplikantoOrderEventArgs
						{
							AverageFillPrice = Delegate153.smethod_0(orderEventArgs, Delegate153.delegate153_0),
							Comment = Delegate154.smethod_0(orderEventArgs, Delegate154.delegate154_0),
							Error = Delegate155.smethod_0(orderEventArgs, Delegate155.delegate155_0),
							Filled = Delegate156.smethod_0(orderEventArgs, Delegate156.delegate156_0),
							LimitPrice = Delegate157.smethod_0(orderEventArgs, Delegate157.delegate157_0),
							OrderStateName = Delegate158.smethod_0(orderEventArgs, Delegate158.YneVagLmKx).ToString(),
							StopPrice = Delegate159.smethod_0(orderEventArgs, Delegate159.delegate159_0),
							Time = Delegate160.smethod_0(orderEventArgs, Delegate160.delegate160_0),
							Quantity = Delegate161.smethod_0(orderEventArgs, Delegate161.delegate161_0)
						});
					}
				}
			}
			try
			{
				Account account4 = Delegate149.smethod_0(Delegate162.smethod_0(e, Delegate162.delegate162_0), Delegate149.delegate149_0);
				Position position;
				if (account4 != null)
				{
					Instrument instrument2 = Delegate143.smethod_0(Delegate162.smethod_0(e, Delegate162.delegate162_0), Delegate143.delegate143_0);
					position = Delegate132.smethod_0(account4, ((instrument2 == null) ? null : new long?(Delegate131.smethod_0(instrument2, Delegate131.delegate131_0))).Value, Delegate132.delegate132_0);
				}
				else
				{
					position = null;
				}
				Position position2 = position;
				replikantoOrder2.LeaderPosition = ReplikantoPosition.Create(position2);
			}
			catch
			{
			}
			return replikantoOrder2;
		}

		public override string ToString()
		{
			PropertyInfo[] array = Delegate166.smethod_0(Delegate165.smethod_0(this, Delegate165.delegate165_0), Delegate166.delegate166_0);
			StringBuilder stringBuilder = new StringBuilder();
			foreach (PropertyInfo propertyInfo in array)
			{
				try
				{
					if (Delegate102.smethod_0(Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "OrderUpdates", Delegate102.delegate102_0))
					{
						Delegate167.smethod_0(stringBuilder, "{0}=[", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate167.delegate167_0);
						foreach (ReplikantoOrderEventArgs replikantoOrderEventArgs in this.OrderUpdates)
						{
							Delegate167.smethod_0(stringBuilder, "{0}, ", Delegate86.smethod_0(replikantoOrderEventArgs, Delegate86.delegate86_0), Delegate167.delegate167_0);
						}
						Delegate168.smethod_0(stringBuilder, "] ", Array.Empty<object>(), Delegate168.delegate168_0);
					}
					else if (Delegate102.smethod_0(Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "OrdersPreviouslySent", Delegate102.delegate102_0))
					{
						Delegate167.smethod_0(stringBuilder, "{0}=[", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate167.delegate167_0);
						foreach (ReplikantoOrder replikantoOrder in this.OrdersPreviouslySent)
						{
							Delegate167.smethod_0(stringBuilder, "{0}, ", replikantoOrder.Id, Delegate167.delegate167_0);
						}
						Delegate168.smethod_0(stringBuilder, "] ", Array.Empty<object>(), Delegate168.delegate168_0);
					}
					else
					{
						Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate169.smethod_0(propertyInfo, this, Delegate169.delegate169_0), Delegate170.delegate170_0);
					}
				}
				catch (TargetInvocationException)
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "null", Delegate170.delegate170_0);
				}
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		public string ToStringSimple()
		{
			return Delegate55.smethod_0("Order id:{0}, orderId: {1}, name: {2}, state: {3}, time: {4:MM/dd/yyyy hh:mm:ss.fff tt}", new object[] { this.Id, this.OrderId, this.Name, this.OrderState, this.Time }, Delegate55.delegate55_0);
		}

		internal bool HasOco()
		{
			return !Delegate171.smethod_0(this.Oco, Delegate171.delegate171_0);
		}

		public override bool Equals(object obj)
		{
			if (!(obj is Order))
			{
				return this.Equals(obj as ReplikantoOrder);
			}
			return Delegate172.smethod_0(this, obj as Order, Delegate172.delegate172_0);
		}

		public override int GetHashCode()
		{
			int num = 91;
			long originalId = this.OriginalId;
			int num2 = ((num + Delegate173.smethod_0(ref originalId, Delegate173.delegate173_0)) * 7 + this.OrderState.GetHashCode()) * 7;
			DateTime time = this.Time;
			return num2 + Delegate174.smethod_0(ref time, Delegate174.delegate174_0);
		}

		public bool Equals(ReplikantoOrder other)
		{
			return other != null && this.OriginalId == other.OriginalId && this.OrderState.Equals(other.OrderState) && Delegate175.smethod_0(this.Time, other.Time, Delegate175.delegate175_0);
		}

		internal static ReplikantoOrder FlatOrder(Account account, Instrument instrument, string id = null)
		{
			return new ReplikantoOrder
			{
				Id = (Delegate44.smethod_0(id, Delegate44.delegate44_0) ? Delegate177.smethod_0(new string(Delegate176.smethod_0(Delegate176.delegate176_0).ToString().Where(new Func<char, bool>(char.IsDigit))
					.ToArray<char>()), 0, 8, Delegate177.delegate177_0) : id),
				OrderId = Delegate101.smethod_0(Delegate176.smethod_0(Delegate176.delegate176_0).ToString(), 0, 8, Delegate101.delegate101_0),
				Name = "Close",
				Oco = string.Empty,
				TifName = 0.ToString(),
				Gtd = Globals.MaxDate,
				Time = Delegate178.smethod_0(Delegate178.delegate178_0),
				StatementDate = Delegate178.smethod_0(Delegate178.delegate178_0),
				StrategyBase = null,
				StrategyName = string.Empty,
				WebStrategyId = 0L,
				InstrumentFullName = ((instrument != null) ? Delegate120.smethod_0(instrument, Delegate120.delegate120_0) : null),
				LimitPrice = 0.0,
				OrderActionName = 0.ToString(),
				OrderEntryName = 1.ToString(),
				OrderStateName = 7.ToString(),
				OrderTypeName = 1.ToString(),
				Quantity = 1,
				Filled = 0,
				StopPrice = 0.0,
				Account = account,
				ReplikantoAccount = new ReplikantoAccount
				{
					AccountName = ((account == null) ? null : Delegate125.smethod_0(account, Delegate125.delegate125_0)),
					DisplayName = ((account != null) ? Delegate126.smethod_0(account, Delegate126.delegate126_0) : null),
					ProviderName = ((account != null) ? Delegate127.smethod_0(account, Delegate127.delegate127_0).ToString() : null)
				}
			};
		}

		public CompositeID GetCompositeID()
		{
			return new CompositeID
			{
				Id = this.OriginalId,
				Name = this.Name
			};
		}

		internal static ReplikantoOrder CreatePartialObject(CompositeID compositeId)
		{
			ReplikantoOrder replikantoOrder = new ReplikantoOrder();
			long id = compositeId.Id;
			replikantoOrder.Id = Delegate109.smethod_0(ref id, Delegate109.delegate109_0);
			replikantoOrder.Name = compositeId.Name;
			return replikantoOrder;
		}

		private long method_0()
		{
			long num;
			try
			{
				if (50 != this.ReplikantoAccount.Provider)
				{
					num = 0L;
				}
				else
				{
					Account account = this.Account;
					ConcurrentDictionary<long, WebStrategyOrderLink> concurrentDictionary = ReplikantoOrder.smethod_0((account != null) ? Delegate180.smethod_0(Delegate179.smethod_0(account, Delegate179.delegate179_0), Delegate180.delegate180_0) : null);
					if (concurrentDictionary == null)
					{
						num = 0L;
					}
					else
					{
						num = concurrentDictionary.FirstOrDefault(new Func<KeyValuePair<long, WebStrategyOrderLink>, bool>(this.method_2)).Key;
					}
				}
			}
			catch
			{
				num = 0L;
			}
			return num;
		}

		private static ConcurrentDictionary<long, WebStrategyOrderLink> smethod_0(object object_0)
		{
			ConcurrentDictionary<long, WebStrategyOrderLink> concurrentDictionary;
			try
			{
				if (object_0 != null && object_0 is Adapter)
				{
					Adapter adapter = (Adapter)object_0;
					if (adapter == null)
					{
						concurrentDictionary = null;
					}
					else
					{
						FieldInfo fieldInfo = Delegate181.smethod_0(Delegate18.smethod_0(adapter, Delegate18.delegate18_0), "strategyOrderLinkMap", BindingFlags.Instance | BindingFlags.NonPublic, Delegate181.delegate181_0);
						concurrentDictionary = JsonConvert.DeserializeObject<ConcurrentDictionary<long, WebStrategyOrderLink>>(JsonConvert.SerializeObject((fieldInfo != null) ? Delegate182.smethod_0(fieldInfo, adapter, Delegate182.delegate182_0) : null, new JsonSerializerSettings
						{
							ContractResolver = new IgnorePropertiesResolver(new string[] { "Account", "Status", "Instrument", "FailureMessage", "TemplateName", "Timestamp" })
						}));
					}
				}
				else
				{
					concurrentDictionary = null;
				}
			}
			catch
			{
				concurrentDictionary = null;
			}
			return concurrentDictionary;
		}

		public WebStrategyOrderLink GetOrdersByStrategyID()
		{
			WebStrategyOrderLink webStrategyOrderLink;
			try
			{
				Account account = this.Account;
				ConcurrentDictionary<long, WebStrategyOrderLink> concurrentDictionary = ReplikantoOrder.smethod_0((account == null) ? null : Delegate180.smethod_0(Delegate179.smethod_0(account, Delegate179.delegate179_0), Delegate180.delegate180_0));
				if (concurrentDictionary == null)
				{
					webStrategyOrderLink = null;
				}
				else
				{
					webStrategyOrderLink = concurrentDictionary.FirstOrDefault(new Func<KeyValuePair<long, WebStrategyOrderLink>, bool>(this.method_3)).Value;
				}
			}
			catch
			{
				webStrategyOrderLink = null;
			}
			return webStrategyOrderLink;
		}

		private static bool smethod_1(object object_0)
		{
			bool flag = false;
			try
			{
				if (Delegate133.smethod_0(object_0, Delegate133.delegate133_0) != null && Delegate133.smethod_0(object_0, Delegate133.delegate133_0) is AtmStrategy)
				{
					flag = Delegate183.smethod_0(object_0, Delegate183.delegate183_0);
				}
				else
				{
					Account account = Delegate149.smethod_0(object_0, Delegate149.delegate149_0);
					if (account != null && Delegate127.smethod_0(account, Delegate127.delegate127_0) == 50)
					{
						IList<OrderEventArgs> list = Delegate152.smethod_0(object_0, Delegate152.delegate152_0);
						if (list != null && list.Count > 0)
						{
							IList<OrderEventArgs> list2 = Delegate152.smethod_0(object_0, Delegate152.delegate152_0);
							bool flag2;
							if (list2 != null)
							{
								OrderEventArgs orderEventArgs = list2.FirstOrDefault<OrderEventArgs>();
								OrderState? orderState = ((orderEventArgs != null) ? new OrderState?(Delegate184.smethod_0(orderEventArgs, Delegate184.delegate184_0)) : null);
								flag2 = (orderState.GetValueOrDefault() == 13) & (orderState != null);
							}
							else
							{
								flag2 = false;
							}
							if (flag2)
							{
								flag = false;
								goto IL_0270;
							}
						}
					}
					string text = Delegate116.smethod_0(object_0, Delegate116.delegate116_0);
					if (text == null || !Delegate185.smethod_0(text, "Entry", Delegate185.delegate185_0))
					{
						string text2 = Delegate116.smethod_0(object_0, Delegate116.delegate116_0);
						if (text2 == null || !Delegate185.smethod_0(text2, "Exit", Delegate185.delegate185_0))
						{
							string text3 = Delegate116.smethod_0(object_0, Delegate116.delegate116_0);
							if (text3 == null || !Delegate185.smethod_0(text3, "Target", Delegate185.delegate185_0))
							{
								string text4 = Delegate116.smethod_0(object_0, Delegate116.delegate116_0);
								if (text4 == null || !Delegate185.smethod_0(text4, "Stop", Delegate185.delegate185_0))
								{
									string text5 = Delegate116.smethod_0(object_0, Delegate116.delegate116_0);
									if (text5 == null || !Delegate185.smethod_0(text5, "SimStop", Delegate185.delegate185_0))
									{
										Account account2 = Delegate149.smethod_0(object_0, Delegate149.delegate149_0);
										Position position = ((account2 == null) ? null : Delegate132.smethod_0(account2, Delegate186.smethod_0(Delegate143.smethod_0(object_0, Delegate143.delegate143_0), Delegate186.delegate186_0), Delegate132.delegate132_0));
										if (position == null || ((position == null || Delegate187.smethod_0(position, Delegate187.delegate187_0) != null) && (position == null || Delegate187.smethod_0(position, Delegate187.delegate187_0) != 1)))
										{
											flag = true;
											goto IL_0270;
										}
										MarketPosition? marketPosition = ((position == null) ? null : new MarketPosition?(Delegate187.smethod_0(position, Delegate187.delegate187_0)));
										MarketPosition? marketPosition2 = marketPosition;
										if (((marketPosition2.GetValueOrDefault() == 0) & (marketPosition2 != null)) && Delegate188.smethod_0(object_0, Delegate188.pWmQjxaAku))
										{
											flag = true;
											goto IL_0270;
										}
										marketPosition2 = marketPosition;
										flag = ((marketPosition2.GetValueOrDefault() == 1) & (marketPosition2 != null)) && Delegate189.smethod_0(object_0, Delegate189.delegate189_0);
										goto IL_0270;
									}
								}
							}
						}
						flag = false;
					}
					else
					{
						flag = true;
					}
				}
				IL_0270:;
			}
			catch
			{
			}
			return flag;
		}

		[Conditional("Debug")]
		private void method_1(string string_12)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("ReplikantoOrder - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), string_12, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		[Conditional("Debug")]
		private static void smethod_2(object object_0)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("ReplikantoOrder - {0:yyyy-MM-dd HH:mm:ss.fff} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), object_0, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		[CompilerGenerated]
		private bool method_2(KeyValuePair<long, WebStrategyOrderLink> keyValuePair_0)
		{
			WebStrategyOrderLink value = keyValuePair_0.Value;
			if (value == null)
			{
				return false;
			}
			HashSet<long> orderIds = value.OrderIds;
			bool? flag = ((orderIds != null) ? new bool?(orderIds.Contains((long)Delegate190.smethod_0(this.OrderId, Delegate190.delegate190_0))) : null);
			return flag.GetValueOrDefault() & (flag != null);
		}

		[CompilerGenerated]
		private bool method_3(KeyValuePair<long, WebStrategyOrderLink> keyValuePair_0)
		{
			WebStrategyOrderLink value = keyValuePair_0.Value;
			if (value == null)
			{
				return false;
			}
			HashSet<long> orderIds = value.OrderIds;
			bool? flag = ((orderIds != null) ? new bool?(orderIds.Contains((long)Delegate190.smethod_0(this.OrderId, Delegate190.delegate190_0))) : null);
			return flag.GetValueOrDefault() & (flag != null);
		}

		internal static object smethod_3(int int_5)
		{
			return Class10.smethod_17(int_5);
		}

		internal static void smethod_4(object object_0, object object_1)
		{
			object_0.Id = object_1;
		}

		internal static void smethod_5(object object_0, DateTime value)
		{
			object_0.Time = value;
		}

		internal static void smethod_6(object object_0, DateTime value)
		{
			object_0.StatementDate = value;
		}

		internal static void smethod_7(object object_0, object object_1)
		{
			object_0.OrderActionName = object_1;
		}

		internal static void smethod_8(object object_0, object object_1)
		{
			object_0.OrderEntryName = object_1;
		}

		internal static void smethod_9(object object_0, object object_1)
		{
			object_0.OrderTypeName = object_1;
		}

		internal static void smethod_10(object object_0, int value)
		{
			object_0.Quantity = value;
		}

		internal static void smethod_11(object object_0, object object_1)
		{
			object_0.TifName = object_1;
		}

		internal static void smethod_12(object object_0, object object_1)
		{
			object_0.AccountName = object_1;
		}

		internal static void smethod_13(object object_0, bool value)
		{
			object_0.IsSimulatedStop = value;
		}

		internal static void smethod_14(object object_0, bool value)
		{
			object_0.IsFromExecution = value;
		}

		internal static void smethod_15(object object_0, bool value)
		{
			object_0.IsLastExit = value;
		}

		internal static void smethod_16(object object_0, int value)
		{
			object_0.ExecutionQuantity = value;
		}

		internal static long smethod_17(object object_0)
		{
			return object_0.OriginalId;
		}

		internal static object smethod_18(object object_0)
		{
			return ReplikantoPosition.Create(object_0);
		}

		internal static void smethod_19(object object_0, object object_1)
		{
			object_0.LeaderPosition = object_1;
		}

		internal static void smethod_20(object object_0, object object_1)
		{
			object_0.OrderId = object_1;
		}

		internal static void smethod_21(object object_0, object object_1)
		{
			object_0.Name = object_1;
		}

		internal static void smethod_22(object object_0, object object_1)
		{
			object_0.Oco = object_1;
		}

		internal static void smethod_23(object object_0, object object_1)
		{
			object_0.StrategyName = object_1;
		}

		internal static void smethod_24(object object_0, long value)
		{
			object_0.StrategyId = value;
		}

		internal static void smethod_25(object object_0, int value)
		{
			object_0.StrategyOrderIndex = value;
		}

		internal static void smethod_26(object object_0, long value)
		{
			object_0.InitialEntryOrder = value;
		}

		internal static void smethod_27(object object_0, object object_1)
		{
			object_0.InstrumentFullName = object_1;
		}

		internal static void smethod_28(object object_0, double value)
		{
			object_0.LimitPrice = value;
		}

		internal static void smethod_29(object object_0, int value)
		{
			object_0.Filled = value;
		}

		internal static void smethod_30(object object_0, object object_1)
		{
			object_0.Account = object_1;
		}

		internal static ScalperTicketOrderType smethod_31(long id)
		{
			return ReplikantoWindow.GetScalperTicketOrderType(id);
		}

		internal static void smethod_32(object object_0, ScalperTicketOrderType value)
		{
			object_0.ScalperTicketOrderType = value;
		}

		internal static void smethod_33(object object_0, object object_1)
		{
			object_0.DisplayName = object_1;
		}

		internal static void smethod_34(object object_0, object object_1)
		{
			object_0.ProviderName = object_1;
		}

		internal static void smethod_35(object object_0, object object_1)
		{
			object_0.ReplikantoAccount = object_1;
		}

		internal static bool smethod_36(object object_0)
		{
			return ReplikantoOrder.smethod_1(object_0);
		}

		internal static void smethod_37(object object_0)
		{
			object_0.Reverse();
		}

		internal static void smethod_38(object object_0, double value)
		{
			object_0.AverageFillPrice = value;
		}

		internal static void smethod_39(object object_0, object object_1)
		{
			object_0.Comment = object_1;
		}

		internal static void smethod_40(object object_0, ErrorCode value)
		{
			object_0.Error = value;
		}

		internal static void smethod_41(object object_0, object object_1)
		{
			object_0.OrderStateName = object_1;
		}

		internal static void smethod_42(object object_0, DateTime value)
		{
			object_0.Time = value;
		}

		internal static void smethod_43(object object_0, int value)
		{
			object_0.Quantity = value;
		}

		internal static void smethod_44(object object_0, DateTime value)
		{
			object_0.Gtd = value;
		}

		internal static void smethod_45(object object_0, object object_1)
		{
			object_0.StrategyBase = object_1;
		}

		internal static void smethod_46(object object_0, object object_1)
		{
			object_0.StrategyOrders = object_1;
		}

		internal static void smethod_47(object object_0, object object_1)
		{
			object_0.OrderStateName = object_1;
		}

		internal static void smethod_48(object object_0, double value)
		{
			object_0.StopPrice = value;
		}

		internal static void smethod_49(object object_0, bool value)
		{
			object_0.IsEntry = value;
		}

		internal static void smethod_50(object object_0, int value)
		{
			object_0.Filled = value;
		}

		internal static void smethod_51(object object_0, double value)
		{
			object_0.StopPrice = value;
		}

		internal static object smethod_52(object object_0)
		{
			return object_0.Id;
		}

		internal static DateTime smethod_53(object object_0)
		{
			return object_0.Time;
		}

		internal static void smethod_54(object object_0, object object_1)
		{
			object_0.Name = object_1;
		}

		internal static object smethod_55(object object_0)
		{
			return object_0.Name;
		}

		internal static Provider smethod_56(object object_0)
		{
			return object_0.Provider;
		}

		internal static void smethod_57()
		{
		}

		internal static void smethod_58()
		{
		}

		[CompilerGenerated]
		private string string_0;

		private long long_0 = -1L;

		[CompilerGenerated]
		private string string_1;

		[CompilerGenerated]
		private long fiuTseEgT;

		private string string_2 = string.Empty;

		[CompilerGenerated]
		private string string_3;

		[CompilerGenerated]
		private string string_4;

		[CompilerGenerated]
		private string string_5;

		[CompilerGenerated]
		private string string_6;

		[CompilerGenerated]
		private string string_7;

		[CompilerGenerated]
		private string string_8;

		[CompilerGenerated]
		private double double_0;

		[CompilerGenerated]
		private double double_1;

		[CompilerGenerated]
		private int int_0;

		[CompilerGenerated]
		private int int_1;

		[CompilerGenerated]
		private string string_9;

		[CompilerGenerated]
		private string string_10;

		[CompilerGenerated]
		private long long_1;

		[CompilerGenerated]
		private int int_2;

		[CompilerGenerated]
		private string string_11;

		[CompilerGenerated]
		private StrategyBase strategyBase_0;

		private long long_2 = -1L;

		[CompilerGenerated]
		private int int_3;

		[CompilerGenerated]
		private DateTime dateTime_0;

		[CompilerGenerated]
		private DateTime dateTime_1;

		[CompilerGenerated]
		private DateTime dateTime_2;

		[CompilerGenerated]
		private Account account_0;

		[CompilerGenerated]
		private ReplikantoAccount replikantoAccount_0;

		[CompilerGenerated]
		private List<ReplikantoOrderEventArgs> list_0;

		[CompilerGenerated]
		private ScalperTicketOrderType scalperTicketOrderType_0;

		[CompilerGenerated]
		private List<ReplikantoOrder> list_1;

		[CompilerGenerated]
		private bool bool_0;

		[CompilerGenerated]
		private bool bool_1;

		[CompilerGenerated]
		private bool bool_2;

		[CompilerGenerated]
		private bool bool_3;

		[CompilerGenerated]
		private bool bool_4;

		[CompilerGenerated]
		private bool bool_5;

		[CompilerGenerated]
		private bool bool_6;

		[CompilerGenerated]
		private bool bool_7;

		[CompilerGenerated]
		private int int_4;

		[CompilerGenerated]
		private ReplikantoPosition replikantoPosition_0;
	}
}
