﻿using System;
using System.Collections.Generic;
using Newtonsoft.Json.Linq;

namespace Replikanto
{
	public class ReplikantoCrossOrderRelationship : BijectiveDictionary<string, string>
	{
		public ReplikantoCrossOrderRelationship()
		{
			try
			{
				IEnumerator<JToken> enumerator = ((JArray)JObject.Parse(Delegate85.smethod_0(ReplikantoCrossOrderRelationship.smethod_2("ReplikantoCrossOrderRelationship.json"), Delegate85.PqjGzimOld))["CrossOrders"]).GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						JObject jobject = (JObject)enumerator.Current;
						base.Add(Delegate86.smethod_0(jobject["mini"], Delegate86.delegate86_0), Delegate86.smethod_0(jobject["micro"], Delegate86.delegate86_0));
					}
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
			}
			catch (Exception)
			{
				base.Add("ES", "MES");
				base.Add("NQ", "MNQ");
				base.Add("YM", "MYM");
				base.Add("6A", "M6A");
				base.Add("6B", "M6B");
				base.Add("6E", "M6E");
				base.Add("6J", "M6J");
				base.Add("6S", "M6S");
				base.Add("GC", "MGC");
				base.Add("ICD", "MICD");
				base.Add("IJY", "MIJY");
				base.Add("ISF", "MISF");
				base.Add("NF", "MNF");
				base.Add("RTY", "M2K");
				base.Add("CL", "MCL");
				base.Add("NG", "MNG");
				base.Add("RB", "QU");
				base.Add("HO", "QH");
				base.Add("ZS", "XK");
				base.Add("ZC", "XC");
				base.Add("ZW", "XW");
				base.Add("FDAX", "FDXM");
				base.Add("FDXM", "FDXS");
				base.Add("HG", "MHG");
				base.Add("BTC", "MBT");
				base.Add("ETH", "MET");
				base.Add("SI", "SIL");
			}
		}

		private static string smethod_2(object object_1)
		{
			return Delegate51.smethod_0(Delegate87.smethod_0(Delegate87.delegate87_0), "bin\\Custom\\", object_1, Delegate51.delegate51_0);
		}

		public bool TryGetCrossOverInstrument(string masterInstrumentName, out string masterIntrument)
		{
			return base.TryGetByFirst(masterInstrumentName, out masterIntrument) || base.TryGetBySecond(masterInstrumentName, out masterIntrument);
		}

		internal static void smethod_3()
		{
		}

		internal static object smethod_4(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_5(object object_1)
		{
			return ReplikantoCrossOrderRelationship.smethod_2(object_1);
		}

		internal static object smethod_6(object object_1)
		{
			return JObject.Parse(object_1);
		}

		internal static object smethod_7(object object_1, object object_2)
		{
			return object_1[object_2];
		}

		internal static void smethod_8()
		{
		}
	}
}
