﻿using System;
using System.Reflection;
using System.Runtime.CompilerServices;
using System.Text;
using Newtonsoft.Json;
using NinjaTrader.Cbi;

namespace Replikanto
{
	public class ReplikantoAccount
	{
		[JsonProperty(PropertyName = "account_name")]
		public string AccountName { get; set; }

		[JsonProperty(PropertyName = "display_name")]
		public string DisplayName { get; set; }

		[JsonProperty(PropertyName = "provider")]
		public string ProviderName { get; set; }

		[JsonIgnore]
		public Provider Provider
		{
			get
			{
				Provider provider;
				try
				{
					provider = (Provider)Delegate106.smethod_0(Delegate45.smethod_0(typeof(Provider).TypeHandle, Delegate45.delegate45_0), this.ProviderName, Delegate106.delegate106_0);
				}
				catch
				{
					provider = 9999;
				}
				return provider;
			}
		}

		public override string ToString()
		{
			PropertyInfo[] array = Delegate166.smethod_0(Delegate165.smethod_0(this, Delegate165.delegate165_0), Delegate166.delegate166_0);
			StringBuilder stringBuilder = new StringBuilder();
			foreach (PropertyInfo propertyInfo in array)
			{
				try
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), Delegate169.smethod_0(propertyInfo, this, Delegate169.delegate169_0), Delegate170.delegate170_0);
				}
				catch (TargetInvocationException)
				{
					Delegate170.smethod_0(stringBuilder, "{0}={1} ", Delegate95.smethod_0(propertyInfo, Delegate95.delegate95_0), "null", Delegate170.delegate170_0);
				}
			}
			return Delegate86.smethod_0(stringBuilder, Delegate86.delegate86_0);
		}

		internal static object smethod_0(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static void smethod_1()
		{
		}

		internal static void smethod_2()
		{
		}

		[CompilerGenerated]
		private string string_0;

		[CompilerGenerated]
		private string string_1;

		[CompilerGenerated]
		private string string_2;
	}
}
