﻿using System;
using System.Net.Http;
using NinjaTrader.Gui.AccountData;

namespace Replikanto
{
	internal class Node : AccountGridEntry, IEquatable<Node>
	{
		public NodeStatus Status
		{
			get
			{
				return this.nodeStatus_0;
			}
			set
			{
				this.nodeStatus_0 = value;
				Delegate216.smethod_0(this, "Status", Delegate216.delegate216_0);
			}
		}

		public string Ip
		{
			get
			{
				return this.string_0;
			}
			set
			{
				this.string_0 = value;
				Delegate216.smethod_0(this, "Ip", Delegate216.delegate216_0);
			}
		}

		public int Port
		{
			get
			{
				return this.int_0;
			}
			set
			{
				this.int_0 = value;
				Delegate216.smethod_0(this, "Port", Delegate216.delegate216_0);
			}
		}

		public string Description
		{
			get
			{
				return this.string_1;
			}
			set
			{
				this.string_1 = value;
				Delegate216.smethod_0(this, "Description", Delegate216.delegate216_0);
			}
		}

		public override string ToString()
		{
			return Delegate82.smethod_0("Node={0}:{1}", this.string_0, this.int_0, Delegate82.delegate82_0);
		}

		public bool Equals(Node other)
		{
			return Delegate102.smethod_0(other.Ip, this.Ip, Delegate102.delegate102_0) && other.Port == this.Port;
		}

		internal void Test()
		{
			if (this.Status != NodeStatus.Off)
			{
				HttpClient httpClient = new HttpClient();
				Delegate232.smethod_0(httpClient, new Uri(Delegate82.smethod_0("http://{0}:{1}/", this.Ip, this.Port, Delegate82.delegate82_0)), Delegate232.delegate232_0);
				Delegate234.smethod_0(httpClient, Delegate233.smethod_0(1.0, Delegate233.delegate233_0), Delegate234.delegate234_0);
				HttpClient httpClient2 = httpClient;
				StringContent stringContent = new StringContent(string.Empty);
				try
				{
					Delegate236.smethod_0(Delegate235.smethod_0(httpClient2, "replikanto_node", stringContent, Delegate235.delegate235_0).Result, Delegate236.delegate236_0);
					this.Status = NodeStatus.Online;
				}
				catch (Exception)
				{
					this.Status = NodeStatus.Away;
				}
			}
		}

		internal static object smethod_0(int int_1)
		{
			return Class10.smethod_17(int_1);
		}

		internal static object smethod_1(object object_0)
		{
			return object_0.Ip;
		}

		internal static int smethod_2(object object_0)
		{
			return object_0.Port;
		}

		internal static void smethod_3()
		{
		}

		internal static void smethod_4()
		{
		}

		private NodeStatus nodeStatus_0;

		private string string_0;

		private int int_0 = 4547;

		private string string_1 = string.Empty;
	}
}
