﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Diagnostics;
using System.Linq;
using System.Reflection;
using System.Timers;
using System.Windows;
using System.Windows.Automation;
using System.Windows.Controls;
using FlowBots.Util;
using NinjaTrader.Cbi;
using NinjaTrader.Core;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Tools;
using Replikanto;
using Replikanto.Communicator;
using Replikanto.Properties;
using Replikanto.Util;

namespace NinjaTrader.NinjaScript.AddOns.FlowBots
{
	internal class ReplikantoFramework : AddOnBase
	{
		public ReplikantoFramework()
		{
			try
			{
				VendorLicense vendorLicense;
				ReplikantoFramework.MachineIdSigned = this.LoadAssignedMachineID(vendorLicense);
				if (ReplikantoFramework.MachineIdSigned == null)
				{
					ReplikantoFramework.MachineIdSigned = Delegate24.smethod_0(Delegate24.delegate24_0);
				}
			}
			catch
			{
				ReplikantoFramework.MachineIdSigned = Delegate24.smethod_0(Delegate24.delegate24_0);
			}
			try
			{
				string text;
				Registry.GetInstance().RegKey("MachineID", ReplikantoFramework.MachineIdSigned, out text, true);
			}
			catch
			{
			}
			ReplikantoFramework.MySelf = this;
		}

		private void NotifyServerActiveState(object sender, ElapsedEventArgs e)
		{
		}

		private static void CheckLicenseOrThrowError(object ex)
		{
			try
			{
				throw ex;
			}
			catch
			{
				throw ex;
			}
		}

		private void CloseAllReplikantoWindows()
		{
			IEnumerator<Window> enumerator = Globals.AllWindows.GetEnumerator();
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					ReplikantoFramework.<>c__DisplayClass15_0 CS$<>8__locals1 = new ReplikantoFramework.<>c__DisplayClass15_0();
					CS$<>8__locals1.window_0 = enumerator.Current;
					if (CS$<>8__locals1.window_0 is ReplikantoWindow)
					{
						Delegate37.smethod_0(Delegate36.smethod_0(CS$<>8__locals1.window_0, Delegate36.delegate36_0), new Action(CS$<>8__locals1.method_0), Delegate37.delegate37_0);
					}
				}
			}
			finally
			{
				if (enumerator != null)
				{
					Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
				}
			}
		}

		private static void ActiveErrorDispatcher(object msg)
		{
			ReplikantoFramework.<>c__DisplayClass16_0 CS$<>8__locals1 = new ReplikantoFramework.<>c__DisplayClass16_0();
			CS$<>8__locals1.string_0 = msg;
			Delegate37.smethod_0(Delegate21.smethod_0(Delegate21.delegate21_0), new Action(CS$<>8__locals1.method_0), Delegate37.delegate37_0);
		}

		protected override void OnStateChange()
		{
		}

		private void MultipleReplikantoWindowsCheck()
		{
			object obj = this.multipleReplikantoWindowsLocker;
			bool flag = false;
			try
			{
				Delegate41.smethod_0(obj, ref flag, Delegate41.delegate41_0);
				try
				{
					string text = Delegate42.smethod_0(Delegate42.delegate42_0);
					List<ReplikantoWindow> list = Globals.AllWindows.ToList<Window>().Where(new Func<Window, bool>(ReplikantoFramework.<>c.<>c_0.method_3)).Cast<ReplikantoWindow>()
						.ToList<ReplikantoWindow>();
					int num = list.Count<ReplikantoWindow>();
					Dictionary<string, uint> dictionary = new Dictionary<string, uint>();
					foreach (ReplikantoWindow replikantoWindow in list)
					{
						string text2 = Delegate43.smethod_0(replikantoWindow, Delegate43.delegate43_0);
						if (Delegate44.smethod_0(text2, Delegate44.delegate44_0))
						{
							text2 = text;
						}
						if (dictionary.ContainsKey(text2))
						{
							uint num2;
							if (dictionary.TryGetValue(text2, out num2))
							{
								dictionary[text2] = num2 + 1U;
							}
						}
						else
						{
							dictionary.Add(text2, 1U);
						}
					}
					if (num > this.multipleReplikantoWindowsFound)
					{
						Delegate34.smethod_0(Delegate32.smethod_0("Replikanto: Windows opened: {0}", num, Delegate32.delegate32_0), 1, Delegate34.delegate34_0);
						if (num > 1)
						{
							Version version = Delegate48.smethod_0(Delegate47.smethod_0(Delegate46.smethod_0(Delegate45.smethod_0(typeof(ReplikantoTabPage).TypeHandle, Delegate45.delegate45_0), Delegate46.delegate46_0), Delegate47.delegate47_0), Delegate48.delegate48_0);
							NTMessageBox ntmessageBox = new NTMessageBox(Delegate50.smethod_0(Resources.MultipleWindows, num, dictionary.Keys.Count, Delegate49.smethod_0(", ", dictionary.Keys, Delegate49.delegate49_0), Delegate50.delegate50_0), Delegate51.smethod_0(Resources.AddOnName, " - ", Resources.MultipleWindowsCaption, Delegate51.delegate51_0), MessageBoxButton.OK, MessageBoxImage.Exclamation);
							Delegate56.smethod_0(ntmessageBox, Delegate55.smethod_0("{0}{1}{2}_{3}", new object[]
							{
								"Multiple",
								Resources.AddOnName,
								"Windows",
								Delegate50.smethod_0("{0}.{1}.{2}", Delegate52.smethod_0(version, Delegate52.delegate52_0), Delegate53.smethod_0(version, Delegate53.delegate53_0), Delegate54.smethod_0(version, Delegate54.delegate54_0), Delegate50.delegate50_0)
							}, Delegate55.delegate55_0), Delegate56.delegate56_0);
							Delegate57.smethod_0(ntmessageBox, false, Delegate57.delegate57_0);
							Delegate58.smethod_0(ntmessageBox, Delegate58.delegate58_0);
						}
					}
					this.multipleReplikantoWindowsFound = num;
				}
				catch (Exception)
				{
				}
			}
			finally
			{
				if (flag)
				{
					Delegate59.smethod_0(obj, Delegate59.delegate59_0);
				}
			}
		}

		public static void ServerActiveCheck()
		{
		}

		private static ReplikantoFramework MySelf { get; set; }

		protected override void OnWindowCreated(Window window)
		{
			if (window is ReplikantoWindow)
			{
				ReplikantoWindow replikantoWindow = window as ReplikantoWindow;
				this.NetworkCheckEvent(replikantoWindow);
				this.MultipleReplikantoWindowsCheck();
			}
			ControlCenter controlCenter = window as ControlCenter;
			if (controlCenter == null)
			{
				return;
			}
			this.existingMenuItemInControlCenter = Delegate60.smethod_0(controlCenter, "ControlCenterMenuItemNew", Delegate60.delegate60_0) as NTMenuItem;
			if (this.existingMenuItemInControlCenter == null)
			{
				return;
			}
			this.baseMenuItem = Delegate60.smethod_0(controlCenter, "FlowBotsMenuItemNew", Delegate60.delegate60_0) as NTMenuItem;
			if (this.baseMenuItem == null)
			{
				NTMenuItem ntmenuItem = new NTMenuItem();
				Delegate61.smethod_0(ntmenuItem, "FlowBots", Delegate61.delegate61_0);
				Delegate64.smethod_0(ntmenuItem, Delegate63.smethod_0(Delegate62.smethod_0(Delegate62.delegate62_0), "MainMenuItem", Delegate63.delegate63_0) as Style, Delegate64.delegate64_0);
				this.baseMenuItem = ntmenuItem;
				Delegate65.smethod_0(this.baseMenuItem, AutomationProperties.AutomationIdProperty, "FlowBotsMenuItemNew", Delegate65.delegate65_0);
				Delegate67.smethod_0(Delegate66.smethod_0(this.existingMenuItemInControlCenter, Delegate66.delegate66_0), this.baseMenuItem, Delegate67.delegate67_0);
			}
			NTMenuItem ntmenuItem2 = new NTMenuItem();
			Delegate61.smethod_0(ntmenuItem2, Resources.AddOnHeader, Delegate61.delegate61_0);
			Delegate64.smethod_0(ntmenuItem2, Delegate63.smethod_0(Delegate62.smethod_0(Delegate62.delegate62_0), "MainMenuItem", Delegate63.delegate63_0) as Style, Delegate64.delegate64_0);
			this.addOnFrameworkMenuItem = ntmenuItem2;
			Delegate67.smethod_0(Delegate66.smethod_0(this.baseMenuItem, Delegate66.delegate66_0), this.addOnFrameworkMenuItem, Delegate67.delegate67_0);
			Delegate68.smethod_0(this.baseMenuItem, new RoutedEventHandler(this.OnMenuItemClick), Delegate68.delegate68_0);
		}

		protected override void OnWindowDestroyed(Window window)
		{
			if (window is ReplikantoWindow)
			{
				ReplikantoWindow replikantoWindow = window as ReplikantoWindow;
				this.NetworkUncheckEvent(replikantoWindow);
				this.multipleReplikantoWindowsFound--;
			}
			if (this.baseMenuItem != null && window is ControlCenter)
			{
				if (this.baseMenuItem != null && Delegate69.smethod_0(Delegate66.smethod_0(this.baseMenuItem, Delegate66.delegate66_0), this.addOnFrameworkMenuItem, Delegate69.delegate69_0))
				{
					Delegate70.smethod_0(Delegate66.smethod_0(this.baseMenuItem, Delegate66.delegate66_0), this.addOnFrameworkMenuItem, Delegate70.delegate70_0);
				}
				Delegate71.smethod_0(this.baseMenuItem, new RoutedEventHandler(this.OnMenuItemClick), Delegate71.delegate71_0);
				this.addOnFrameworkMenuItem = null;
			}
			bool flag = false;
			IEnumerator<Window> enumerator = Globals.AllWindows.GetEnumerator();
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					if (enumerator.Current is ReplikantoWindow)
					{
						flag = true;
						break;
					}
				}
			}
			finally
			{
				if (enumerator != null)
				{
					Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
				}
			}
			if (!flag)
			{
				NT7NetworkFactory.Create().Stop();
				NetworkFactory.Create().Stop();
			}
		}

		private void OnMenuItemClick(object sender, RoutedEventArgs e)
		{
			if (Delegate72.smethod_0(e, Delegate72.delegate72_0) == this.addOnFrameworkMenuItem)
			{
				Delegate74.smethod_0(Delegate73.smethod_0(Delegate73.delegate73_0), new Action(ReplikantoFramework.<>c.<>c_0.method_4), Array.Empty<object>(), Delegate74.delegate74_0);
			}
		}

		private void NetworkCheckEvent(ReplikantoWindow rw)
		{
			IEnumerator enumerator = Delegate75.smethod_0(Delegate66.smethod_0(rw.TabControl, Delegate66.delegate66_0), Delegate75.delegate75_0);
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					Delegate78.smethod_0(((ReplikantoTabPage)Delegate77.smethod_0((TabItem)Delegate76.smethod_0(enumerator, Delegate76.delegate76_0), Delegate77.delegate77_0)).cbNetworkMode, new RoutedEventHandler(this.NetworkUnchecked), Delegate78.delegate78_0);
				}
			}
			finally
			{
				IDisposable disposable = enumerator as IDisposable;
				if (disposable != null)
				{
					Delegate39.smethod_0(disposable, Delegate39.delegate39_0);
				}
			}
		}

		private void NetworkUncheckEvent(ReplikantoWindow rw)
		{
			IEnumerator enumerator = Delegate75.smethod_0(Delegate66.smethod_0(rw.TabControl, Delegate66.delegate66_0), Delegate75.delegate75_0);
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					Delegate79.smethod_0(((ReplikantoTabPage)Delegate77.smethod_0((TabItem)Delegate76.smethod_0(enumerator, Delegate76.delegate76_0), Delegate77.delegate77_0)).cbNetworkMode, new RoutedEventHandler(this.NetworkUnchecked), Delegate79.delegate79_0);
				}
			}
			finally
			{
				IDisposable disposable = enumerator as IDisposable;
				if (disposable != null)
				{
					Delegate39.smethod_0(disposable, Delegate39.delegate39_0);
				}
			}
		}

		private void NetworkUnchecked(object sender, RoutedEventArgs e)
		{
			bool flag = true;
			IEnumerator<Window> enumerator = Globals.AllWindows.GetEnumerator();
			try
			{
				while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
				{
					Window window = enumerator.Current;
					ReplikantoFramework.<>c__DisplayClass29_0 CS$<>8__locals1 = new ReplikantoFramework.<>c__DisplayClass29_0();
					CS$<>8__locals1.replikantoWindow_0 = window as ReplikantoWindow;
					if (CS$<>8__locals1.replikantoWindow_0 != null && !Delegate36.smethod_0(CS$<>8__locals1.replikantoWindow_0, Delegate36.delegate36_0).Invoke<bool>(new Func<bool>(CS$<>8__locals1.method_0)))
					{
						flag = false;
						break;
					}
				}
			}
			finally
			{
				if (enumerator != null)
				{
					Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
				}
			}
			if (flag)
			{
				NetworkFactory.Create().Stop();
			}
		}

		private string LoadAssignedMachineID(VendorLicense mvl)
		{
			if (mvl == null)
			{
				return null;
			}
			return (string)Delegate80.smethod_0(Delegate45.smethod_0(typeof(VendorLicense).TypeHandle, Delegate45.delegate45_0), "GetID", BindingFlags.Instance | BindingFlags.NonPublic, Delegate80.delegate80_0).Invoke(mvl, null);
		}

		[Conditional("Debug")]
		private void Print(string msg)
		{
			Delegate83.smethod_0(Delegate82.smethod_0("Framework - {0:yyyy-MM-dd HH.mm.ss} - {1}", Delegate81.smethod_0(Delegate81.delegate81_0), msg, Delegate82.delegate82_0), 0, Delegate83.delegate83_0);
		}

		internal static void smethod_0()
		{
		}

		internal static object smethod_1()
		{
			return Registry.GetInstance();
		}

		internal static void smethod_2(object object_0)
		{
			ReplikantoFramework.MySelf = object_0;
		}

		internal static void smethod_3(object object_0)
		{
			ReplikantoFramework.CheckLicenseOrThrowError(object_0);
		}

		internal static object smethod_4(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_5()
		{
			return Resources.ActivationError;
		}

		internal static void smethod_6(object object_0)
		{
			ReplikantoFramework.ActiveErrorDispatcher(object_0);
		}

		internal static object smethod_7()
		{
			return ReplikantoFramework.<MySelf>k__BackingField;
		}

		internal static object smethod_8()
		{
			return Resources.MultipleWindows;
		}

		internal static int smethod_9(object object_0)
		{
			return object_0.Count;
		}

		internal static object smethod_10()
		{
			return Resources.AddOnName;
		}

		internal static object smethod_11()
		{
			return Resources.MultipleWindowsCaption;
		}

		internal static object smethod_12()
		{
			return Resources.AddOnHeader;
		}

		internal static object smethod_13()
		{
			return NT7NetworkFactory.Create();
		}

		internal static void smethod_14(object object_0)
		{
			object_0.Stop();
		}

		internal static object smethod_15()
		{
			return NetworkFactory.Create();
		}

		internal static object smethod_16(object object_0)
		{
			return object_0.TabControl;
		}

		internal static object smethod_17(object object_0, object object_1, object object_2)
		{
			return object_0.Invoke(object_1, object_2);
		}

		internal static void smethod_18()
		{
		}

		internal static void smethod_19()
		{
		}

		public static readonly string vendorName;

		public static readonly string productName;

		public static readonly string vendorWebsite;

		public static readonly string vendorEmail;

		private NTMenuItem baseMenuItem;

		private NTMenuItem addOnFrameworkMenuItem;

		private NTMenuItem existingMenuItemInControlCenter;

		private FlowBotsProductVersion.Product product;

		public static string MachineIdSigned;

		private Timer timer;

		private int multipleReplikantoWindowsFound;

		private readonly object multipleReplikantoWindowsLocker = new object();
	}
}
