﻿using System;

namespace Newtonsoft.Json.Utilities
{
	internal readonly struct TypeNameKey : IEquatable<TypeNameKey>
	{
		public TypeNameKey(string assemblyName, string typeName)
		{
			this.AssemblyName = assemblyName;
			this.TypeName = typeName;
		}

		public override int GetHashCode()
		{
			string assemblyName = this.AssemblyName;
			int num = ((assemblyName != null) ? assemblyName.GetHashCode() : 0);
			string typeName = this.TypeName;
			return num ^ ((typeName != null) ? typeName.GetHashCode() : 0);
		}

		public override bool Equals(object obj)
		{
			return obj is TypeNameKey && this.Equals((TypeNameKey)obj);
		}

		public bool Equals(TypeNameKey other)
		{
			return this.AssemblyName == other.AssemblyName && this.TypeName == other.TypeName;
		}

		internal readonly string AssemblyName;

		internal readonly string TypeName;
	}
}
