﻿using System;
using System.Collections.Generic;
using System.Xml.Linq;

namespace Newtonsoft.Json.Converters
{
	internal class XContainerWrapper : XObjectWrapper
	{
		private XContainer Container
		{
			get
			{
				return (XContainer)base.WrappedNode;
			}
		}

		public XContainerWrapper(XContainer container)
			: base(container)
		{
		}

		public override List<IXmlNode> ChildNodes
		{
			get
			{
				if (this._childNodes == null)
				{
					if (!this.HasChildNodes)
					{
						this._childNodes = XmlNodeConverter.EmptyChildNodes;
					}
					else
					{
						this._childNodes = new List<IXmlNode>();
						foreach (XNode xnode in this.Container.Nodes())
						{
							this._childNodes.Add(XContainerWrapper.WrapNode(xnode));
						}
					}
				}
				return this._childNodes;
			}
		}

		protected virtual bool HasChildNodes
		{
			get
			{
				return this.Container.LastNode != null;
			}
		}

		public override IXmlNode ParentNode
		{
			get
			{
				if (this.Container.Parent == null)
				{
					return null;
				}
				return XContainerWrapper.WrapNode(this.Container.Parent);
			}
		}

		internal static IXmlNode WrapNode(XObject node)
		{
			XDocument xdocument;
			if ((xdocument = node as XDocument) != null)
			{
				return new XDocumentWrapper(xdocument);
			}
			XElement xelement;
			if ((xelement = node as XElement) != null)
			{
				return new XElementWrapper(xelement);
			}
			XContainer xcontainer;
			if ((xcontainer = node as XContainer) != null)
			{
				return new XContainerWrapper(xcontainer);
			}
			XProcessingInstruction xprocessingInstruction;
			if ((xprocessingInstruction = node as XProcessingInstruction) != null)
			{
				return new XProcessingInstructionWrapper(xprocessingInstruction);
			}
			XText xtext;
			if ((xtext = node as XText) != null)
			{
				return new XTextWrapper(xtext);
			}
			XComment xcomment;
			if ((xcomment = node as XComment) != null)
			{
				return new XCommentWrapper(xcomment);
			}
			XAttribute xattribute;
			if ((xattribute = node as XAttribute) != null)
			{
				return new XAttributeWrapper(xattribute);
			}
			XDocumentType xdocumentType;
			if ((xdocumentType = node as XDocumentType) != null)
			{
				return new Class5(xdocumentType);
			}
			return new XObjectWrapper(node);
		}

		public override IXmlNode AppendChild(IXmlNode newChild)
		{
			this.Container.Add(newChild.WrappedNode);
			this._childNodes = null;
			return newChild;
		}

		private List<IXmlNode> _childNodes;
	}
}
