﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq.Expressions;
using System.Reflection;

namespace Replikanto
{
	public static class LocalizationUtilities
	{
		public static LocalizedValueCollection GetEnumLocalization<T>() where T : struct
		{
			return LocalizationUtilities.GetEnumLocalization(Delegate45.smethod_0(typeof(T).TypeHandle, Delegate45.delegate45_0));
		}

		public static LocalizedValueCollection GetEnumLocalization(Type type)
		{
			LocalizedValueCollection localizedValueCollection;
			if (!LocalizationUtilities.idictionary_0.TryGetValue(type, out localizedValueCollection))
			{
				IList<LocalizedValue> list = new List<LocalizedValue>();
				IEnumerator enumerator = Delegate91.smethod_0(Delegate90.smethod_0(type, Delegate90.delegate90_0), Delegate91.delegate91_0);
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						object obj = Delegate76.smethod_0(enumerator, Delegate76.delegate76_0);
						DisplayAttribute customAttribute = Delegate92.smethod_0(type, Delegate86.smethod_0(obj, Delegate86.delegate86_0), Delegate92.delegate92_0).GetCustomAttribute<DisplayAttribute>();
						if (customAttribute != null)
						{
							list.Add(new LocalizedValue(obj, customAttribute));
						}
						else
						{
							list.Add(new LocalizedValue(obj, Delegate86.smethod_0(obj, Delegate86.delegate86_0)));
						}
					}
				}
				finally
				{
					IDisposable disposable = enumerator as IDisposable;
					if (disposable != null)
					{
						Delegate39.smethod_0(disposable, Delegate39.delegate39_0);
					}
				}
				LocalizedValueCollection localizedValueCollection2 = new LocalizedValueCollection(list);
				LocalizationUtilities.idictionary_0.Add(type, localizedValueCollection2);
				return localizedValueCollection2;
			}
			return localizedValueCollection;
		}

		public static string GetPropertyLocalization<T>(Expression<Func<T>> exp)
		{
			object obj;
			if (!LocalizationUtilities.idictionary_1.TryGetValue(exp, out obj))
			{
				MemberExpression memberExpression = (MemberExpression)Delegate93.smethod_0(exp, Delegate93.delegate93_0);
				DisplayAttribute customAttribute = Delegate94.smethod_0(memberExpression, Delegate94.delegate94_0).GetCustomAttribute<DisplayAttribute>();
				if (customAttribute == null)
				{
					obj = Delegate95.smethod_0(Delegate94.smethod_0(memberExpression, Delegate94.delegate94_0), Delegate95.delegate95_0);
				}
				else
				{
					obj = Delegate96.smethod_0(customAttribute, Delegate96.delegate96_0);
				}
				LocalizationUtilities.idictionary_1.Add(exp, obj);
			}
			DisplayAttribute displayAttribute = obj as DisplayAttribute;
			if (displayAttribute != null)
			{
				return Delegate96.smethod_0(displayAttribute, Delegate96.delegate96_0);
			}
			return Delegate86.smethod_0(obj, Delegate86.delegate86_0);
		}

		public static string GetEnumMemberLocalization(Enum value)
		{
			if (value == null)
			{
				throw new ArgumentNullException("value");
			}
			return LocalizationUtilities.GetEnumLocalization(Delegate18.smethod_0(value, Delegate18.delegate18_0))[value].Name;
		}

		internal static object smethod_0(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static object smethod_1(Type type)
		{
			return LocalizationUtilities.GetEnumLocalization(type);
		}

		internal static object smethod_2(object object_0, object object_1)
		{
			return object_0[object_1];
		}

		internal static object smethod_3(object object_0)
		{
			return object_0.Name;
		}

		internal static void smethod_4()
		{
		}

		private static readonly IDictionary<Type, LocalizedValueCollection> idictionary_0 = new Dictionary<Type, LocalizedValueCollection>();

		private static readonly IDictionary<Expression, object> idictionary_1 = new Dictionary<Expression, object>();
	}
}
