﻿using System;
using System.Diagnostics;
using System.Net;
using System.Threading.Tasks;
using System.Web.Script.Serialization;

namespace FlowBots.Util
{
	public sealed class VersionCheck
	{
		public static async Task<Tuple<bool, FlowBotsProductVersion.Product>> CheckVersionAsync(string id, string productStr, Version localVersion)
		{
			bool needUpgrade = false;
			WebClient wc = new WebClient();
			Tuple<bool, FlowBotsProductVersion.Product> tuple;
			try
			{
				Version fileVersion = null;
				FlowBotsProductVersion.Product fileProduct;
				if (VersionCheck.smethod_0(productStr, out fileProduct))
				{
					fileVersion = new Version(fileProduct.file_version);
					DateTime dateTime = new DateTime(fileProduct.LastCheckTime, DateTimeKind.Utc);
					if (Delegate776.smethod_0(Delegate774.smethod_0(ref dateTime, (double)VersionCheck.int_0, Delegate774.delegate774_0), Delegate775.smethod_0(Delegate775.delegate775_0), Delegate776.delegate776_0) > 0)
					{
						return new Tuple<bool, FlowBotsProductVersion.Product>(false, fileProduct);
					}
				}
				string text = await Delegate781.smethod_0(wc, Delegate288.smethod_0(new string[]
				{
					"https://flowbots.ninja/wp-json/flowbots/v1/version/",
					id,
					"/",
					productStr,
					"/",
					Delegate86.smethod_0(localVersion, Delegate86.delegate86_0)
				}, Delegate288.delegate288_0), Delegate781.delegate781_0);
				FlowBotsProductVersion.Product[] products = new JavaScriptSerializer().Deserialize<FlowBotsProductVersion>(text).products;
				int i = 0;
				while (i < products.Length)
				{
					FlowBotsProductVersion.Product product = products[i];
					if (Delegate778.smethod_0(productStr, product.file_name, Delegate778.delegate778_0) != 0)
					{
						i++;
					}
					else
					{
						Version version = new Version(product.file_version);
						FlowBotsProductVersion.Product product2 = product;
						if (fileProduct != null && Delegate295.smethod_0(fileVersion, version, Delegate295.delegate295_0) == 0 && fileProduct.DoNotShow)
						{
							product.DoNotShow = true;
							VersionCheck.PersistProductVersion(product);
							needUpgrade = false;
							return new Tuple<bool, FlowBotsProductVersion.Product>(needUpgrade, product2);
						}
						VersionCheck.PersistProductVersion(product);
						needUpgrade = Delegate295.smethod_0(localVersion, version, Delegate295.delegate295_0) < 0;
						return new Tuple<bool, FlowBotsProductVersion.Product>(needUpgrade, product2);
					}
				}
				tuple = new Tuple<bool, FlowBotsProductVersion.Product>(needUpgrade, null);
			}
			catch
			{
				tuple = new Tuple<bool, FlowBotsProductVersion.Product>(needUpgrade, null);
			}
			finally
			{
				if (wc != null)
				{
					Delegate39.smethod_0(wc, Delegate39.delegate39_0);
				}
			}
			return tuple;
		}

		public static bool TryCheckVersion(string id, string productStr, Version localVersion, out bool needUpgrade, out FlowBotsProductVersion.Product product)
		{
			needUpgrade = false;
			product = null;
			WebClient webClient = new WebClient();
			bool flag;
			try
			{
				Version version = null;
				FlowBotsProductVersion.Product product2;
				if (VersionCheck.smethod_0(productStr, out product2))
				{
					version = new Version(product2.file_version);
					DateTime dateTime = new DateTime(product2.LastCheckTime, DateTimeKind.Utc);
					if (Delegate776.smethod_0(Delegate774.smethod_0(ref dateTime, (double)VersionCheck.int_0, Delegate774.delegate774_0), Delegate775.smethod_0(Delegate775.delegate775_0), Delegate776.delegate776_0) > 0)
					{
						return false;
					}
				}
				string text = Delegate777.smethod_0(webClient, Delegate288.smethod_0(new string[]
				{
					"https://flowbots.ninja/wp-json/flowbots/v1/version/",
					id,
					"/",
					productStr,
					"/",
					Delegate86.smethod_0(localVersion, Delegate86.delegate86_0)
				}, Delegate288.delegate288_0), Delegate777.delegate777_0);
				FlowBotsProductVersion.Product[] products = new JavaScriptSerializer().Deserialize<FlowBotsProductVersion>(text).products;
				int i = 0;
				while (i < products.Length)
				{
					FlowBotsProductVersion.Product product3 = products[i];
					if (Delegate778.smethod_0(productStr, product3.file_name, Delegate778.delegate778_0) != 0)
					{
						i++;
					}
					else
					{
						Version version2 = new Version(product3.file_version);
						product = product3;
						if (product2 != null && Delegate295.smethod_0(version, version2, Delegate295.delegate295_0) == 0 && product2.DoNotShow)
						{
							product3.DoNotShow = true;
							VersionCheck.PersistProductVersion(product3);
							needUpgrade = false;
							return true;
						}
						VersionCheck.PersistProductVersion(product3);
						needUpgrade = Delegate295.smethod_0(localVersion, version2, Delegate295.delegate295_0) < 0;
						return true;
					}
				}
				flag = false;
			}
			catch
			{
				flag = false;
			}
			finally
			{
				if (webClient != null)
				{
					Delegate39.smethod_0(webClient, Delegate39.delegate39_0);
				}
			}
			return flag;
		}

		public static void DeletePersistantProductVersion(string productName)
		{
			try
			{
				Delegate509.smethod_0(VersionCheck.smethod_1(productName), Delegate509.delegate509_0);
			}
			catch
			{
			}
		}

		public static bool PersistProductVersion(FlowBotsProductVersion.Product product)
		{
			bool flag;
			try
			{
				string text = Delegate779.smethod_0(new JavaScriptSerializer(), product, Delegate779.delegate779_0);
				Delegate489.smethod_0(VersionCheck.smethod_1(product.file_name), text, Delegate489.delegate489_0);
				return true;
			}
			catch
			{
				flag = false;
			}
			return flag;
		}

		private static bool smethod_0(object object_0, out FlowBotsProductVersion.Product product_0)
		{
			product_0 = null;
			bool flag;
			try
			{
				string text = Delegate85.smethod_0(VersionCheck.smethod_1(object_0), Delegate85.PqjGzimOld);
				JavaScriptSerializer javaScriptSerializer = new JavaScriptSerializer();
				product_0 = javaScriptSerializer.Deserialize<FlowBotsProductVersion.Product>(text);
				return true;
			}
			catch
			{
				flag = false;
			}
			return flag;
		}

		private static string smethod_1(object object_0)
		{
			return Delegate303.smethod_0(Delegate780.smethod_0(Delegate780.delegate780_0), "bin\\Custom\\FlowBots.", object_0, ".json", Delegate303.delegate303_0);
		}

		[Conditional("Debug")]
		private static void smethod_2(object object_0)
		{
			Delegate773.smethod_0(object_0, 0, Delegate773.delegate773_0);
		}

		internal static object smethod_3(object object_0)
		{
			return object_0.file_version;
		}

		internal static long smethod_4(object object_0)
		{
			return object_0.LastCheckTime;
		}

		internal static object smethod_5(int int_1)
		{
			return Class10.smethod_17(int_1);
		}

		internal static bool smethod_6(object object_0)
		{
			return object_0.DoNotShow;
		}

		internal static void smethod_7(object object_0, bool value)
		{
			object_0.DoNotShow = value;
		}

		internal static bool smethod_8(object object_0)
		{
			return VersionCheck.PersistProductVersion(object_0);
		}

		internal static object smethod_9(object object_0)
		{
			return object_0.file_name;
		}

		internal static object smethod_10(object object_0)
		{
			return VersionCheck.smethod_1(object_0);
		}

		internal static void smethod_11()
		{
		}

		internal static void smethod_12()
		{
		}

		private static readonly int int_0 = 60;
	}
}
