﻿using System;
using System.Collections.Concurrent;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Runtime.CompilerServices;
using System.Threading;
using NinjaTrader.Cbi;
using NinjaTrader.Data;
using NinjaTrader.Gui.Tools.Account;

namespace FlowBots.Util
{
	public class AveragePrice
	{
		public event EventHandler<AveragePriceEventArgs> AveragePriceChange
		{
			[CompilerGenerated]
			add
			{
				EventHandler<AveragePriceEventArgs> eventHandler = this.eventHandler_0;
				EventHandler<AveragePriceEventArgs> eventHandler2;
				do
				{
					eventHandler2 = eventHandler;
					EventHandler<AveragePriceEventArgs> eventHandler3 = (EventHandler<AveragePriceEventArgs>)Delegate544.smethod_0(eventHandler2, value, Delegate544.delegate544_0);
					eventHandler = Interlocked.CompareExchange<EventHandler<AveragePriceEventArgs>>(ref this.eventHandler_0, eventHandler3, eventHandler2);
				}
				while (eventHandler != eventHandler2);
			}
			[CompilerGenerated]
			remove
			{
				EventHandler<AveragePriceEventArgs> eventHandler = this.eventHandler_0;
				EventHandler<AveragePriceEventArgs> eventHandler2;
				do
				{
					eventHandler2 = eventHandler;
					EventHandler<AveragePriceEventArgs> eventHandler3 = (EventHandler<AveragePriceEventArgs>)Delegate545.smethod_0(eventHandler2, value, Delegate545.delegate545_0);
					eventHandler = Interlocked.CompareExchange<EventHandler<AveragePriceEventArgs>>(ref this.eventHandler_0, eventHandler3, eventHandler2);
				}
				while (eventHandler != eventHandler2);
			}
		}

		public event EventHandler<PnLEventArgs> Event_0
		{
			[CompilerGenerated]
			add
			{
				EventHandler<PnLEventArgs> eventHandler = this.eventHandler_1;
				EventHandler<PnLEventArgs> eventHandler2;
				do
				{
					eventHandler2 = eventHandler;
					EventHandler<PnLEventArgs> eventHandler3 = (EventHandler<PnLEventArgs>)Delegate544.smethod_0(eventHandler2, value, Delegate544.delegate544_0);
					eventHandler = Interlocked.CompareExchange<EventHandler<PnLEventArgs>>(ref this.eventHandler_1, eventHandler3, eventHandler2);
				}
				while (eventHandler != eventHandler2);
			}
			[CompilerGenerated]
			remove
			{
				EventHandler<PnLEventArgs> eventHandler = this.eventHandler_1;
				EventHandler<PnLEventArgs> eventHandler2;
				do
				{
					eventHandler2 = eventHandler;
					EventHandler<PnLEventArgs> eventHandler3 = (EventHandler<PnLEventArgs>)Delegate545.smethod_0(eventHandler2, value, Delegate545.delegate545_0);
					eventHandler = Interlocked.CompareExchange<EventHandler<PnLEventArgs>>(ref this.eventHandler_1, eventHandler3, eventHandler2);
				}
				while (eventHandler != eventHandler2);
			}
		}

		public AveragePrice()
		{
			this.method_0();
		}

		public double AvgPrice { get; private set; }

		public double AvgPriceCommissioned { get; private set; }

		public double PnL { get; private set; }

		public double PnLCommissioned { get; private set; }

		public bool FromClosedPosition { get; private set; }

		private void method_0()
		{
			this.bool_0 = false;
			this.AvgPrice = 0.0;
			this.AvgPriceCommissioned = 0.0;
			this.instrumentCommission_0 = null;
			this.PnL = 0.0;
			this.FromClosedPosition = false;
			this.double_2 = 0.0;
			this.double_3 = 0.0;
			this.int_0 = 0;
			this.concurrentBag_0 = new ConcurrentBag<Execution>();
			this.concurrentBag_1 = new ConcurrentBag<Execution>();
		}

		private bool method_1(int int_1)
		{
			string text = "AveragePrice> CalcAveragePrice> Thread> ";
			int num = Delegate745.smethod_0(Delegate744.smethod_0(Delegate744.delegate744_0), Delegate745.delegate745_0);
			this.ObRasGqScU(Delegate33.smethod_0(text, Delegate220.smethod_0(ref num, Delegate220.xReoabdegl), Delegate33.delegate33_0));
			this.AvgPrice = 0.0;
			this.AvgPriceCommissioned = 0.0;
			if (this.Instrument == null)
			{
				return false;
			}
			if (this.Account != null)
			{
				int num2 = -int_1;
				this.int_0 = int_1;
				if (!this.bool_0)
				{
					this.concurrentBag_1.Take(this.concurrentBag_0.Count);
				}
				DateTime dateTime = Delegate746.smethod_0(Delegate81.smethod_0(Delegate81.delegate81_0), DateTimeKind.Unspecified, Delegate746.delegate746_0);
				DateTime dateTime2 = Delegate746.smethod_0(Delegate747.smethod_0(Delegate747.delegate747_0), DateTimeKind.Unspecified, Delegate746.delegate746_0);
				double num3 = 0.0;
				double num4 = 0.0;
				int num5 = -1;
				int num6 = 1;
				int num7 = this.concurrentBag_1.Count - 1;
				int num8 = 0;
				int num9 = 0;
				bool flag = false;
				for (;;)
				{
					if (this.bool_0)
					{
						IOrderedEnumerable<Execution> orderedEnumerable = this.concurrentBag_0.OrderBy(new Func<Execution, DateTime>(AveragePrice.<>c.<>c_0.method_3));
						num7 = orderedEnumerable.Count<Execution>() - 1;
						goto IL_0133;
					}
					dateTime2 = Delegate737.smethod_0(ref dateTime, (double)num5, Delegate737.delegate737_0);
					Collection<Execution> collection = Delegate739.smethod_0(this.Account, this.Instrument, dateTime2, dateTime, Delegate739.delegate739_0);
					if (collection != null && collection.Count != 0)
					{
						IEnumerator<Execution> enumerator = collection.GetEnumerator();
						try
						{
							while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
							{
								Execution execution = enumerator.Current;
								this.concurrentBag_1.Add(execution);
							}
						}
						finally
						{
							if (enumerator != null)
							{
								Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
							}
						}
						IOrderedEnumerable<Execution> orderedEnumerable = this.concurrentBag_1.OrderBy(new Func<Execution, DateTime>(AveragePrice.<>c.<>c_0.method_2));
						num7 = orderedEnumerable.Count<Execution>() - 1 - num8;
						goto IL_0133;
					}
					flag = true;
					dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
					num5 -= ++num6;
					IL_0428:
					if (flag)
					{
						continue;
					}
					break;
					IL_0133:
					for (int i = num7; i >= 0; i--)
					{
						IOrderedEnumerable<Execution> orderedEnumerable;
						Execution execution2 = orderedEnumerable.ElementAt(i);
						if (!this.bool_0)
						{
							this.concurrentBag_0.Add(execution2);
						}
						num2 += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution2, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution2, Delegate722.delegate722_0)));
						num9 += Delegate722.smethod_0(execution2, Delegate722.delegate722_0);
						this.ObRasGqScU(Delegate51.smethod_0(Delegate220.smethod_0(ref i, Delegate220.xReoabdegl), " ADD to list: ", Delegate86.smethod_0(execution2, Delegate86.delegate86_0), Delegate51.delegate51_0));
						num3 += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) != null) ? (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)(-(double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0))) : (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0)));
						num4 += Delegate724.smethod_0(execution2, Delegate724.delegate724_0);
						if (!this.bool_0 && i == 0 && num2 != 0)
						{
							flag = true;
							dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
							num5 -= ++num6;
							num8 = num7 + 1;
						}
						else
						{
							if (num2 == 0)
							{
								string[] array = new string[6];
								array[0] = "Position quantity ";
								array[1] = Delegate220.smethod_0(ref int_1, Delegate220.xReoabdegl);
								array[2] = ", i ";
								array[3] = Delegate220.smethod_0(ref i, Delegate220.xReoabdegl);
								array[4] = ", Executions quantity ";
								int num10 = 5;
								num = this.concurrentBag_0.Count;
								array[num10] = Delegate220.smethod_0(ref num, Delegate220.xReoabdegl);
								this.ObRasGqScU(Delegate288.smethod_0(array, Delegate288.delegate288_0));
								flag = false;
								if (int_1 == 0)
								{
									this.FromClosedPosition = true;
									this.AvgPrice = Delegate723.smethod_0(execution2, Delegate723.delegate723_0) + num3 / (double)num9 * (double)((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? (-1) : 1);
									this.AvgPriceCommissioned = this.AvgPrice + num4 / this.double_0 * this.double_1 * (double)((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) != null) ? 1 : (-1));
								}
								else
								{
									this.FromClosedPosition = false;
									this.AvgPrice = Delegate379.smethod_0(num3 / (double)int_1, Delegate379.delegate379_0);
									this.AvgPriceCommissioned = this.AvgPrice + num4 / this.double_0 / (double)int_1 * this.double_1;
								}
								string text2 = "Avg ";
								double num11 = this.AvgPrice;
								string text3 = Delegate748.smethod_0(ref num11, Delegate748.delegate748_0);
								string text4 = ", AvgComm ";
								num11 = this.AvgPriceCommissioned;
								this.ObRasGqScU(Delegate303.smethod_0(text2, text3, text4, Delegate748.smethod_0(ref num11, Delegate748.delegate748_0), Delegate303.delegate303_0));
								this.bool_0 = true;
								this.eventHandler_0(this, new AveragePriceEventArgs
								{
									AvgPrice = this.AvgPrice,
									AvgPriceCommissioned = this.AvgPriceCommissioned,
									FromClosedPosition = (int_1 == 0)
								});
								break;
							}
							if (i == 0 && num2 != 0)
							{
								this.ObRasGqScU("Não foi possível calcular o Avg.");
								flag = false;
								break;
							}
						}
					}
					goto IL_0428;
				}
				return false;
			}
			return false;
		}

		public Instrument Instrument
		{
			get
			{
				return this.instrument_0;
			}
			set
			{
				string text = "AveragePrice> Instrument> Thread> ";
				int num = Delegate745.smethod_0(Delegate744.smethod_0(Delegate744.delegate744_0), Delegate745.delegate745_0);
				this.ObRasGqScU(Delegate33.smethod_0(text, Delegate220.smethod_0(ref num, Delegate220.xReoabdegl), Delegate33.delegate33_0));
				this.method_0();
				this.instrument_0 = value;
				this.double_1 = Delegate727.smethod_0(Delegate726.smethod_0(value, Delegate726.delegate726_0), Delegate727.delegate727_0);
				this.double_0 = this.double_1 * Delegate728.smethod_0(Delegate726.smethod_0(value, Delegate726.delegate726_0), Delegate728.delegate728_0);
				int num2;
				if (!this.method_2(out num2))
				{
					this.eventHandler_0(this, new AveragePriceEventArgs
					{
						AvgPrice = this.AvgPrice,
						AvgPriceCommissioned = this.AvgPriceCommissioned
					});
					this.eventHandler_1(this, new PnLEventArgs
					{
						PnL = this.PnL,
						PnLCommissioned = this.PnLCommissioned
					});
				}
				else
				{
					try
					{
						this.method_1(num2);
					}
					catch (Exception ex)
					{
						this.ObRasGqScU(Delegate86.smethod_0(ex, Delegate86.delegate86_0));
					}
				}
			}
		}

		public Account Account
		{
			get
			{
				return this.account_0;
			}
			set
			{
				string text = "AveragePrice> Account> Thread> ";
				int num = Delegate745.smethod_0(Delegate744.smethod_0(Delegate744.delegate744_0), Delegate745.delegate745_0);
				this.ObRasGqScU(Delegate33.smethod_0(text, Delegate220.smethod_0(ref num, Delegate220.xReoabdegl), Delegate33.delegate33_0));
				if (this.account_0 != null)
				{
					Delegate749.smethod_0(this.account_0, new EventHandler<ExecutionEventArgs>(this.method_4), Delegate749.delegate749_0);
					Delegate750.smethod_0(this.account_0, new EventHandler<PositionEventArgs>(this.method_3), Delegate750.delegate750_0);
					Delegate751.smethod_0(this.account_0, new EventHandler<OrderEventArgs>(this.OnOrderUpdate), Delegate751.delegate751_0);
				}
				this.method_0();
				this.account_0 = value;
				Delegate752.smethod_0(value, new EventHandler<ExecutionEventArgs>(this.method_4), Delegate752.delegate752_0);
				Delegate753.smethod_0(value, new EventHandler<PositionEventArgs>(this.method_3), Delegate753.delegate753_0);
				Delegate754.smethod_0(value, new EventHandler<OrderEventArgs>(this.OnOrderUpdate), Delegate754.delegate754_0);
				int num2;
				if (this.method_2(out num2))
				{
					try
					{
						this.method_1(num2);
						return;
					}
					catch (Exception ex)
					{
						this.ObRasGqScU(Delegate86.smethod_0(ex, Delegate86.delegate86_0));
						return;
					}
				}
				this.eventHandler_0(this, new AveragePriceEventArgs
				{
					AvgPrice = this.AvgPrice,
					AvgPriceCommissioned = this.AvgPriceCommissioned
				});
				this.eventHandler_1(this, new PnLEventArgs
				{
					PnL = this.PnL,
					PnLCommissioned = this.PnLCommissioned
				});
			}
		}

		private bool method_2(out int int_1)
		{
			if (this.Account != null && this.Instrument != null)
			{
				IEnumerator<Position> enumerator = Delegate755.smethod_0(this.Account, Delegate755.delegate755_0).GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						Position position = enumerator.Current;
						if (position != null && Delegate738.smethod_0(position, Delegate738.delegate738_0) != null && Delegate756.smethod_0(Delegate738.smethod_0(position, Delegate738.delegate738_0), Delegate756.delegate756_0) == Delegate756.smethod_0(this.Instrument, Delegate756.delegate756_0))
						{
							int_1 = ((Delegate741.smethod_0(position, Delegate741.delegate741_0) == null) ? Delegate742.smethod_0(position, Delegate742.delegate742_0) : (-Delegate742.smethod_0(position, Delegate742.delegate742_0)));
							return true;
						}
					}
					goto IL_00CA;
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
				bool flag;
				return flag;
			}
			IL_00CA:
			this.FromClosedPosition = true;
			int_1 = 0;
			return false;
		}

		private void OnOrderUpdate(object sender, OrderEventArgs e)
		{
			if (this.Instrument == null)
			{
				return;
			}
			if (Delegate756.smethod_0(Delegate758.smethod_0(Delegate757.smethod_0(e, Delegate757.delegate757_0), Delegate758.delegate758_0), Delegate756.delegate756_0) != Delegate756.smethod_0(this.Instrument, Delegate756.delegate756_0))
			{
				return;
			}
			if (Delegate759.smethod_0(e, Delegate759.delegate759_0) == 2)
			{
				this.bool_1 = false;
				return;
			}
			if (Delegate759.smethod_0(e, Delegate759.delegate759_0) == 4)
			{
				this.bool_1 = true;
			}
		}

		private void method_3(object sender, PositionEventArgs e)
		{
			string text = "AveragePrice> OnPositionUpdate> Thread> ";
			int num = Delegate745.smethod_0(Delegate744.smethod_0(Delegate744.delegate744_0), Delegate745.delegate745_0);
			this.ObRasGqScU(Delegate33.smethod_0(text, Delegate220.smethod_0(ref num, Delegate220.xReoabdegl), Delegate33.delegate33_0));
			if (this.Instrument == null)
			{
				return;
			}
			if (Delegate756.smethod_0(Delegate738.smethod_0(Delegate760.smethod_0(e, Delegate760.delegate760_0), Delegate738.delegate738_0), Delegate756.delegate756_0) != Delegate756.smethod_0(this.Instrument, Delegate756.delegate756_0))
			{
				return;
			}
			if (!this.bool_1)
			{
				bool flag = false;
				int num2 = ((Delegate761.smethod_0(e, Delegate761.delegate761_0) == null) ? Delegate762.smethod_0(e, Delegate762.delegate762_0) : ((Delegate761.smethod_0(e, Delegate761.delegate761_0) == 1) ? (-Delegate762.smethod_0(e, Delegate762.delegate762_0)) : 0));
				if (this.int_0 == 0 && num2 != 0)
				{
					flag = true;
				}
				try
				{
					this.method_1(num2);
					if (!flag)
					{
						if (this.int_0 == 0)
						{
							Delegate764.smethod_0(this.instrument_0, new EventHandler<MarketDataEventArgs>(this.method_5), Delegate764.delegate764_0);
							this.method_0();
						}
					}
					else
					{
						Delegate763.smethod_0(this.instrument_0, new EventHandler<MarketDataEventArgs>(this.method_5), Delegate763.delegate763_0);
					}
				}
				catch (Exception ex)
				{
					this.ObRasGqScU(Delegate86.smethod_0(ex, Delegate86.delegate86_0));
				}
			}
		}

		private void method_4(object sender, ExecutionEventArgs e)
		{
			string text = "AveragePrice> OnExecutionUpdate> Thread> ";
			int num = Delegate745.smethod_0(Delegate744.smethod_0(Delegate744.delegate744_0), Delegate745.delegate745_0);
			this.ObRasGqScU(Delegate33.smethod_0(text, Delegate220.smethod_0(ref num, Delegate220.xReoabdegl), Delegate33.delegate33_0));
			if (this.Instrument == null)
			{
				return;
			}
			if (Delegate756.smethod_0(Delegate725.smethod_0(Delegate765.smethod_0(e, Delegate765.delegate765_0), Delegate725.delegate725_0), Delegate756.delegate756_0) != Delegate756.smethod_0(this.Instrument, Delegate756.delegate756_0))
			{
				return;
			}
			this.double_2 = 0.0;
			this.double_3 = 0.0;
			try
			{
				this.concurrentBag_0.Add(Delegate765.smethod_0(e, Delegate765.delegate765_0));
				this.bool_0 = true;
			}
			catch (Exception ex)
			{
				this.ObRasGqScU(Delegate86.smethod_0(ex, Delegate86.delegate86_0));
			}
		}

		private void method_5(object sender, MarketDataEventArgs e)
		{
			if (!Delegate766.smethod_0(e, Delegate766.delegate766_0) && !this.concurrentBag_0.IsEmpty)
			{
				if (this.instrumentCommission_0 == null && this.Account != null && this.Instrument != null)
				{
					this.instrumentCommission_0 = Delegate769.smethod_0(Delegate768.smethod_0(Delegate767.smethod_0(new AccountWrapper(this.Account), Delegate767.delegate767_0), Delegate768.delegate768_0), Delegate769.SpolmefAvE)[Delegate726.smethod_0(this.Instrument, Delegate726.delegate726_0)];
				}
				if (Delegate770.smethod_0(e, Delegate770.QoXlftaghq) == 1 && Delegate721.smethod_0(this.concurrentBag_0.First<Execution>(), Delegate721.delegate721_0) == null)
				{
					if (this.double_2 == Delegate771.smethod_0(e, Delegate771.delegate771_0))
					{
						return;
					}
					this.double_2 = Delegate771.smethod_0(e, Delegate771.delegate771_0);
					this.PnL = (this.double_2 - this.AvgPrice) / this.double_1 * this.double_0 * (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0);
					this.PnLCommissioned = (this.double_2 - this.AvgPriceCommissioned) / this.double_1 * this.double_0 * (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0);
					if (this.instrumentCommission_0 != null)
					{
						this.PnLCommissioned -= (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0) * Delegate772.smethod_0(this.instrumentCommission_0, Delegate772.delegate772_0);
					}
					this.eventHandler_1(this, new PnLEventArgs
					{
						PnL = this.PnL,
						PnLCommissioned = this.PnLCommissioned
					});
				}
				else if (Delegate770.smethod_0(e, Delegate770.QoXlftaghq) == null && Delegate721.smethod_0(this.concurrentBag_0.First<Execution>(), Delegate721.delegate721_0) == 1)
				{
					if (this.double_3 == Delegate771.smethod_0(e, Delegate771.delegate771_0))
					{
						return;
					}
					this.double_3 = Delegate771.smethod_0(e, Delegate771.delegate771_0);
					this.PnL = (this.AvgPrice - this.double_3) / this.double_1 * this.double_0 * (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0);
					this.PnLCommissioned = (this.AvgPriceCommissioned - this.double_3) / this.double_1 * this.double_0 * (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0);
					if (this.instrumentCommission_0 != null)
					{
						this.PnLCommissioned -= (double)Delegate732.smethod_0(this.int_0, Delegate732.delegate732_0) * Delegate772.smethod_0(this.instrumentCommission_0, Delegate772.delegate772_0);
					}
					this.eventHandler_1(this, new PnLEventArgs
					{
						PnL = this.PnL,
						PnLCommissioned = this.PnLCommissioned
					});
				}
				if (this.int_0 == 0)
				{
					this.ObRasGqScU("OnMarketData> positionQuantity == 0 ou reset");
				}
				return;
			}
			this.PnL = 0.0;
		}

		private void ObRasGqScU(string string_0)
		{
			Delegate773.smethod_0(string_0, 0, Delegate773.delegate773_0);
		}

		internal static void smethod_0()
		{
		}

		internal static object smethod_1(int int_1)
		{
			return Class10.smethod_17(int_1);
		}

		internal static int smethod_2(object object_0)
		{
			return object_0.Count;
		}

		internal static int smethod_3(object object_0)
		{
			return object_0.Count;
		}

		internal static void smethod_4(object object_0, double value)
		{
			object_0.AvgPrice = value;
		}

		internal static void smethod_5(object object_0, double value)
		{
			object_0.AvgPriceCommissioned = value;
		}

		internal static void smethod_6(object object_0, double value)
		{
			object_0.PnL = value;
		}

		internal static void smethod_7(object object_0, double value)
		{
			object_0.PnLCommissioned = value;
		}

		internal static bool smethod_8(object object_0)
		{
			return object_0.IsEmpty;
		}

		internal static void smethod_9()
		{
		}

		private ConcurrentBag<Execution> concurrentBag_0;

		private ConcurrentBag<Execution> concurrentBag_1;

		private Account account_0;

		private Instrument instrument_0;

		private double double_0;

		private double double_1;

		private double double_2;

		private double double_3;

		private int int_0;

		private bool bool_0;

		private bool bool_1;

		[CompilerGenerated]
		private EventHandler<AveragePriceEventArgs> eventHandler_0 = new EventHandler<AveragePriceEventArgs>(AveragePrice.<>c.<>c_0.method_0);

		[CompilerGenerated]
		private EventHandler<PnLEventArgs> eventHandler_1 = new EventHandler<PnLEventArgs>(AveragePrice.<>c.<>c_0.method_1);

		private InstrumentCommission instrumentCommission_0;

		[CompilerGenerated]
		private double double_4;

		[CompilerGenerated]
		private double double_5;

		[CompilerGenerated]
		private double double_6;

		[CompilerGenerated]
		private double double_7;

		[CompilerGenerated]
		private bool bool_2;
	}
}
