﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Runtime.CompilerServices;
using NinjaTrader.Cbi;
using NinjaTrader.NinjaScript;

namespace FlowBots.Util
{
	public class AverageCalculation
	{
		[CompilerGenerated]
		private static NinjaScript smethod_0()
		{
			return AverageCalculation.ninjaScript_0;
		}

		[CompilerGenerated]
		private static void smethod_1(NinjaScript ninjaScript_1)
		{
			AverageCalculation.ninjaScript_0 = ninjaScript_1;
		}

		public static void Init(NinjaScript ns_local)
		{
			AverageCalculation.smethod_1(ns_local);
		}

		private static void smethod_2(object object_0)
		{
		}

		public static bool TryCalculateAveragePrice(List<Execution> executions, out double averagePrice, out double averagePriceCommissioned, int positionQuantity = 0, MarketPosition marketPosition = 2)
		{
			averagePrice = double.MinValue;
			averagePriceCommissioned = double.MinValue;
			if (executions != null && executions.Count != 0)
			{
				int num = ((marketPosition == null) ? (-positionQuantity) : positionQuantity);
				int num2 = 0;
				int num3 = 0;
				double num4 = 0.0;
				double num5 = 0.0;
				IOrderedEnumerable<Execution> orderedEnumerable = executions.OrderByDescending(new Func<Execution, DateTime>(AverageCalculation.<>c.<>c_0.method_0));
				Execution execution = orderedEnumerable.Last<Execution>();
				IEnumerator<Execution> enumerator = orderedEnumerable.GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						Execution execution2 = enumerator.Current;
						num2 += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution2, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution2, Delegate722.delegate722_0)));
						num4 += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0)) : (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)(-(double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0))));
						num5 += Delegate724.smethod_0(execution2, Delegate724.delegate724_0);
						num3 += Delegate722.smethod_0(execution2, Delegate722.delegate722_0);
						AverageCalculation.smethod_2(Delegate33.smethod_0("TryCalculateAveragePrice> New Avg ", Delegate86.smethod_0(execution2, Delegate86.delegate86_0), Delegate33.delegate33_0));
						if (num2 + num == 0)
						{
							double num6 = Delegate727.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution2, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate727.delegate727_0);
							double num7 = num6 * Delegate728.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution2, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate728.delegate728_0);
							if (positionQuantity != 0)
							{
								if (Delegate729.smethod_0(execution2, Delegate729.delegate729_0) != null && Delegate730.smethod_0(Delegate729.smethod_0(execution2, Delegate729.delegate729_0), Delegate730.delegate730_0) != Delegate722.smethod_0(execution2, Delegate722.delegate722_0))
								{
									if (execution2 != execution)
									{
										continue;
									}
								}
								averagePrice = Delegate379.smethod_0(num4 / (double)positionQuantity * (double)((marketPosition == 1) ? (-1) : 1), Delegate379.delegate379_0);
								averagePriceCommissioned = averagePrice + num5 / num7 / (double)positionQuantity * num6 * (double)((marketPosition == 1) ? (-1) : 1);
								return true;
							}
							averagePrice = Delegate723.smethod_0(execution2, Delegate723.delegate723_0) + num4 / (double)num3 * (double)((marketPosition == null) ? (-1) : 1);
							averagePriceCommissioned = averagePrice + num5 / num7 * num6 * (double)((marketPosition == null) ? (-1) : 1);
							return true;
						}
					}
					return false;
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
				bool flag;
				return flag;
			}
			AverageCalculation.smethod_2(Delegate32.smethod_0("TryCalculateAveragePrice> executions null or empty {0}", executions, Delegate32.delegate32_0));
			return false;
		}

		public static bool TryCalculateAveragePrice2(List<Execution> executions, out double averagePrice, out double averagePriceCommissioned, int positionQuantity, MarketPosition marketPosition = 2)
		{
			averagePrice = double.MinValue;
			averagePriceCommissioned = double.MinValue;
			if (executions != null && executions.Count != 0)
			{
				if (positionQuantity > 0)
				{
					marketPosition = 0;
				}
				else if (positionQuantity < 0)
				{
					marketPosition = 1;
				}
				else if (marketPosition == 2)
				{
					Delegate731.smethod_0(Delegate82.smethod_0("TryCalculateAveragePrice2> Warning, position quantity: {0}, could not receive a market position: {1}", positionQuantity, marketPosition, Delegate82.delegate82_0), 2, Delegate731.delegate731_0);
					return false;
				}
				int num = 0;
				int num2 = 0;
				double num3 = 0.0;
				double num4 = 0.0;
				IOrderedEnumerable<Execution> orderedEnumerable = executions.OrderByDescending(new Func<Execution, DateTime>(AverageCalculation.<>c.<>c_0.method_1));
				Execution execution = orderedEnumerable.Last<Execution>();
				IEnumerator<Execution> enumerator = orderedEnumerable.GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						Execution execution2 = enumerator.Current;
						num += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution2, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution2, Delegate722.delegate722_0)));
						num3 += ((Delegate721.smethod_0(execution2, Delegate721.delegate721_0) == null) ? (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0)) : (Delegate723.smethod_0(execution2, Delegate723.delegate723_0) * (double)(-(double)Delegate722.smethod_0(execution2, Delegate722.delegate722_0))));
						num4 += Delegate724.smethod_0(execution2, Delegate724.delegate724_0);
						num2 += Delegate722.smethod_0(execution2, Delegate722.delegate722_0);
						AverageCalculation.smethod_2(Delegate33.smethod_0("TryCalculateAveragePrice2> New Avg ", Delegate86.smethod_0(execution2, Delegate86.delegate86_0), Delegate33.delegate33_0));
						if (num - positionQuantity == 0)
						{
							double num5 = Delegate727.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution2, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate727.delegate727_0);
							double num6 = num5 * Delegate728.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution2, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate728.delegate728_0);
							if (positionQuantity != 0)
							{
								if (Delegate729.smethod_0(execution2, Delegate729.delegate729_0) != null && Delegate730.smethod_0(Delegate729.smethod_0(execution2, Delegate729.delegate729_0), Delegate730.delegate730_0) != Delegate722.smethod_0(execution2, Delegate722.delegate722_0))
								{
									if (execution2 != execution)
									{
										continue;
									}
								}
								averagePrice = Delegate379.smethod_0(num3 / (double)Delegate732.smethod_0(positionQuantity, Delegate732.delegate732_0) * (double)((marketPosition == 1) ? (-1) : 1), Delegate379.delegate379_0);
								averagePriceCommissioned = averagePrice + num4 / num6 / (double)Delegate732.smethod_0(positionQuantity, Delegate732.delegate732_0) * num5 * (double)((marketPosition == 1) ? (-1) : 1);
								return true;
							}
							averagePrice = Delegate723.smethod_0(execution2, Delegate723.delegate723_0) + num3 / (double)num2 * (double)((marketPosition == null) ? (-1) : 1);
							averagePriceCommissioned = averagePrice + num4 / num6 * num5 * (double)((marketPosition == null) ? (-1) : 1);
							return true;
						}
					}
					return false;
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
				bool flag;
				return flag;
			}
			AverageCalculation.smethod_2(Delegate32.smethod_0("TryCalculateAveragePrice2> executions null or empty {0}", executions, Delegate32.delegate32_0));
			return false;
		}

		public static bool TryCalculateAveragePrice3(List<Execution> executions, out double averagePrice, out double averagePriceCommissioned, int positionQuantity)
		{
			averagePrice = double.MinValue;
			averagePriceCommissioned = double.MinValue;
			if (executions != null && executions.Count != 0)
			{
				IOrderedEnumerable<Execution> orderedEnumerable = executions.OrderByDescending(new Func<Execution, DateTime>(AverageCalculation.<>c.<>c_0.method_2));
				Execution execution = orderedEnumerable.Last<Execution>();
				string text = "TryCalculateAveragePrice3> First: ";
				Execution execution2 = execution;
				AverageCalculation.smethod_2(Delegate33.smethod_0(text, (execution2 != null) ? Delegate86.smethod_0(execution2, Delegate86.delegate86_0) : null, Delegate33.delegate33_0));
				MarketPosition marketPosition = Delegate721.smethod_0(execution, Delegate721.delegate721_0);
				if (positionQuantity > 0)
				{
					marketPosition = 0;
				}
				else if (positionQuantity < 0)
				{
					marketPosition = 1;
				}
				int num = 0;
				int num2 = 0;
				double num3 = 0.0;
				double num4 = 0.0;
				IEnumerator<Execution> enumerator = orderedEnumerable.GetEnumerator();
				try
				{
					while (Delegate38.smethod_0(enumerator, Delegate38.delegate38_0))
					{
						Execution execution3 = enumerator.Current;
						num += ((Delegate721.smethod_0(execution3, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution3, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution3, Delegate722.delegate722_0)));
						num3 += ((Delegate721.smethod_0(execution3, Delegate721.delegate721_0) == null) ? (Delegate723.smethod_0(execution3, Delegate723.delegate723_0) * (double)Delegate722.smethod_0(execution3, Delegate722.delegate722_0)) : (Delegate723.smethod_0(execution3, Delegate723.delegate723_0) * (double)(-(double)Delegate722.smethod_0(execution3, Delegate722.delegate722_0))));
						num4 += Delegate724.smethod_0(execution3, Delegate724.delegate724_0);
						num2 += Delegate722.smethod_0(execution3, Delegate722.delegate722_0);
						AverageCalculation.smethod_2(Delegate50.smethod_0("TryCalculateAveragePrice3> Execution {0} QTY {1}, Position QTY {2}", Delegate733.smethod_0(execution3, Delegate733.delegate733_0), num, positionQuantity, Delegate50.delegate50_0));
						if (num - positionQuantity == 0)
						{
							double num5 = Delegate727.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution3, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate727.delegate727_0);
							double num6 = num5 * Delegate728.smethod_0(Delegate726.smethod_0(Delegate725.smethod_0(execution3, Delegate725.delegate725_0), Delegate726.delegate726_0), Delegate728.delegate728_0);
							if (positionQuantity != 0)
							{
								if (Delegate729.smethod_0(execution3, Delegate729.delegate729_0) != null && Delegate730.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate730.delegate730_0) != Delegate722.smethod_0(execution3, Delegate722.delegate722_0))
								{
									if (execution3 != execution)
									{
										continue;
									}
								}
								averagePrice = Delegate379.smethod_0(num3 / (double)Delegate732.smethod_0(positionQuantity, Delegate732.delegate732_0) * (double)((marketPosition == 1) ? (-1) : 1), Delegate379.delegate379_0);
								averagePriceCommissioned = averagePrice + num4 / num6 / (double)Delegate732.smethod_0(positionQuantity, Delegate732.delegate732_0) * num5 * (double)((marketPosition == 1) ? (-1) : 1);
								AverageCalculation.smethod_2(Delegate82.smethod_0("TryCalculateAveragePrice3> AvgPrice {0}, AvgPrice Comm {1}", averagePrice, averagePriceCommissioned, Delegate82.delegate82_0));
								return true;
							}
							averagePrice = Delegate723.smethod_0(execution3, Delegate723.delegate723_0) + num3 / (double)num2 * (double)((marketPosition == null) ? (-1) : 1);
							averagePriceCommissioned = averagePrice + num4 / num6 * num5 * (double)((marketPosition == null) ? (-1) : 1);
							AverageCalculation.smethod_2(Delegate82.smethod_0("TryCalculateAveragePrice3> AvgPrice {0}, AvgPrice Comm {1}", averagePrice, averagePriceCommissioned, Delegate82.delegate82_0));
							return true;
						}
					}
					goto IL_030C;
				}
				finally
				{
					if (enumerator != null)
					{
						Delegate39.smethod_0(enumerator, Delegate39.delegate39_0);
					}
				}
				bool flag;
				return flag;
				IL_030C:
				AverageCalculation.smethod_2(Delegate33.smethod_0("Executions have not match the position quantity ", Delegate220.smethod_0(ref positionQuantity, Delegate220.xReoabdegl), Delegate33.delegate33_0));
				Delegate731.smethod_0(Delegate33.smethod_0("Executions have not match the position quantity ", Delegate220.smethod_0(ref positionQuantity, Delegate220.xReoabdegl), Delegate33.delegate33_0), 2, Delegate731.delegate731_0);
				return false;
			}
			AverageCalculation.smethod_2(Delegate32.smethod_0("TryCalculateAveragePrice3> executions null or empty {0}", executions, Delegate32.delegate32_0));
			return false;
		}

		public static bool TryGetExecutions(Position position, out List<Execution> executions)
		{
			executions = new List<Execution>();
			if (position == null)
			{
				return false;
			}
			AverageCalculation.smethod_2(Delegate32.smethod_0("TryGetExecutions> Loading executions for position: {0}", position, Delegate32.delegate32_0));
			bool flag = false;
			Execution execution = null;
			bool flag2;
			try
			{
				Account account = Delegate734.smethod_0(position, Delegate734.delegate734_0);
				Execution execution2;
				if (account == null)
				{
					execution2 = null;
				}
				else
				{
					Collection<Execution> collection = Delegate735.smethod_0(account, Delegate735.delegate735_0);
					execution2 = ((collection == null) ? null : collection.Last<Execution>());
				}
				execution = execution2;
				goto IL_005D;
			}
			catch
			{
				flag2 = false;
			}
			return flag2;
			IL_005D:
			if (execution != null)
			{
				DateTime dateTime = Delegate736.smethod_0(execution, Delegate736.delegate736_0);
				int num = -1;
				int num2 = 1;
				int num3 = 0;
				int i;
				for (;;)
				{
					DateTime dateTime2 = Delegate737.smethod_0(ref dateTime, (double)num, Delegate737.delegate737_0);
					AverageCalculation.smethod_2(Delegate55.smethod_0("TryGetExecutions> Loading executions for {0} and {1}, from {2} to {3}", new object[]
					{
						Delegate734.smethod_0(position, Delegate734.delegate734_0),
						Delegate738.smethod_0(position, Delegate738.delegate738_0),
						dateTime2,
						dateTime
					}, Delegate55.delegate55_0));
					Collection<Execution> collection2 = Delegate739.smethod_0(Delegate734.smethod_0(position, Delegate734.delegate734_0), Delegate738.smethod_0(position, Delegate738.delegate738_0), dateTime2, dateTime, Delegate739.delegate739_0);
					if (collection2 != null && collection2.Count != 0)
					{
						executions.InsertRange(0, collection2.OrderBy(new Func<Execution, DateTime>(AverageCalculation.<>c.<>c_0.method_3)).ToList<Execution>());
						int num4 = executions.Count<Execution>() - 1 - num3;
						int num5 = ((Delegate741.smethod_0(position, Delegate741.delegate741_0) != null) ? Delegate742.smethod_0(position, Delegate742.delegate742_0) : (-Delegate742.smethod_0(position, Delegate742.delegate742_0)));
						AverageCalculation.smethod_2(Delegate32.smethod_0("TryGetExecutions> Quantity to check {0}", -num5, Delegate32.delegate32_0));
						int num6 = 0;
						for (i = num4; i >= 0; i--)
						{
							Execution execution3 = executions[i];
							if (execution3 != null)
							{
								num6 += ((Delegate721.smethod_0(execution3, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution3, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution3, Delegate722.delegate722_0)));
								AverageCalculation.smethod_2(Delegate82.smethod_0("TryGetExecutions> {0} = {1}", execution3, num6, Delegate82.delegate82_0));
								if (num6 + num5 == 0)
								{
									if (Delegate729.smethod_0(execution3, Delegate729.delegate729_0) == null || Delegate730.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate730.delegate730_0) == Delegate722.smethod_0(execution3, Delegate722.delegate722_0))
									{
										goto IL_0341;
									}
									AverageCalculation.smethod_2(Delegate82.smethod_0("TryGetExecutions> Execution with different order quantity, not yet completed. Order Quantity: {0} != Execution Quantity: {1}", Delegate730.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate730.delegate730_0), Delegate722.smethod_0(execution3, Delegate722.delegate722_0), Delegate82.delegate82_0));
								}
							}
						}
						if (num6 + num5 != 0)
						{
							AverageCalculation.smethod_2(Delegate82.smethod_0("TryGetExecutions> Quantity to check {0} != execution quantity {1}", -num5, num6, Delegate82.delegate82_0));
							flag = true;
							dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
							num -= ++num2;
							num3 = num4 + 1;
							AverageCalculation.smethod_2("TryGetExecutions> Loading more...");
						}
					}
					else
					{
						AverageCalculation.smethod_2("TryGetExecutions> Not found executions for this period");
						flag = true;
						dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
						num -= ++num2;
					}
					if (!flag)
					{
						return false;
					}
				}
				IL_0341:
				executions.RemoveRange(0, i);
				AverageCalculation.smethod_2("TryGetExecutions> Quantity Checked!");
				return true;
			}
			return false;
		}

		public static bool TryGetExecutions3(Position position, out List<Execution> executions)
		{
			executions = new List<Execution>();
			if (position != null)
			{
				bool flag = false;
				Execution execution = null;
				try
				{
					Account account = Delegate734.smethod_0(position, Delegate734.delegate734_0);
					Execution execution2;
					if (account == null)
					{
						execution2 = null;
					}
					else
					{
						Collection<Execution> collection = Delegate735.smethod_0(account, Delegate735.delegate735_0);
						execution2 = ((collection == null) ? null : collection.Last<Execution>());
					}
					execution = execution2;
					if (execution == null)
					{
						AverageCalculation.smethod_2(Delegate32.smethod_0("TryGetExecutions3> Zero executions for position: {0}", position, Delegate32.delegate32_0));
						return false;
					}
				}
				catch
				{
					return false;
				}
				DateTime dateTime = Delegate736.smethod_0(execution, Delegate736.delegate736_0);
				int num = -1;
				int num2 = 1;
				int num3 = 0;
				int num4 = 0;
				int num5 = ((Delegate741.smethod_0(position, Delegate741.delegate741_0) == null) ? (-Delegate742.smethod_0(position, Delegate742.delegate742_0)) : Delegate742.smethod_0(position, Delegate742.delegate742_0));
				int num6 = 0;
				string text = "";
				int i;
				for (;;)
				{
					DateTime dateTime2;
					try
					{
						dateTime2 = Delegate737.smethod_0(ref dateTime, (double)num, Delegate737.delegate737_0);
					}
					catch (ArgumentOutOfRangeException)
					{
						return false;
					}
					Collection<Execution> collection2 = Delegate739.smethod_0(Delegate734.smethod_0(position, Delegate734.delegate734_0), Delegate738.smethod_0(position, Delegate738.delegate738_0), dateTime2, dateTime, Delegate739.delegate739_0);
					if (collection2 != null && collection2.Count != 0)
					{
						try
						{
							executions.InsertRange(0, collection2.OrderBy(new Func<Execution, DateTime>(AverageCalculation.<>c.<>c_0.method_4)).ToList<Execution>());
						}
						catch (ArgumentNullException)
						{
							return false;
						}
						int num7 = executions.Count<Execution>() - 1 - num3;
						for (i = num7; i >= 0; i--)
						{
							Execution execution3 = executions[i];
							if (execution3 != null)
							{
								num4 += ((Delegate721.smethod_0(execution3, Delegate721.delegate721_0) == null) ? Delegate722.smethod_0(execution3, Delegate722.delegate722_0) : (-Delegate722.smethod_0(execution3, Delegate722.delegate722_0)));
								if (!Delegate104.smethod_0(Delegate743.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate743.delegate743_0), text, Delegate104.delegate104_0))
								{
									num6 += Delegate722.smethod_0(execution3, Delegate722.delegate722_0);
								}
								else
								{
									text = Delegate743.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate743.delegate743_0);
									num6 = Delegate722.smethod_0(execution3, Delegate722.delegate722_0);
								}
								if (num4 + num5 == 0)
								{
									if (Delegate730.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate730.delegate730_0) == num6)
									{
										goto IL_031E;
									}
									AverageCalculation.smethod_2(Delegate82.smethod_0("TryGetExecutions3> Execution with different order quantity, not yet completed. Order Quantity: {0} != Execution Quantity: {1}", Delegate730.smethod_0(Delegate729.smethod_0(execution3, Delegate729.delegate729_0), Delegate730.delegate730_0), Delegate722.smethod_0(execution3, Delegate722.delegate722_0), Delegate82.delegate82_0));
								}
							}
						}
						if (num4 + num5 != 0)
						{
							AverageCalculation.smethod_2(Delegate82.smethod_0("TryGetExecutions3> Quantity to check {0} != execution quantity {1}", -num5, num4, Delegate82.delegate82_0));
							flag = true;
							dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
							num -= ++num2;
							num3 = num7 + 1;
							AverageCalculation.smethod_2("TryGetExecutions3> Loading more...");
						}
					}
					else
					{
						AverageCalculation.smethod_2("TryGetExecutions3> Not found executions for this period");
						flag = true;
						dateTime = Delegate740.smethod_0(ref dateTime2, -1.0, Delegate740.delegate740_0);
						num -= ++num2;
					}
					if (!flag)
					{
						return false;
					}
				}
				IL_031E:
				executions.RemoveRange(0, i);
				return true;
			}
			return false;
		}

		public static bool smethod_3(double averagePrice, double marketPrice, int positionQuantity, Instrument instrument, out double pnl)
		{
			if (instrument == null)
			{
				pnl = double.MinValue;
				return false;
			}
			double num = Delegate727.smethod_0(Delegate726.smethod_0(instrument, Delegate726.delegate726_0), Delegate727.delegate727_0);
			double num2 = num * Delegate728.smethod_0(Delegate726.smethod_0(instrument, Delegate726.delegate726_0), Delegate728.delegate728_0);
			if (positionQuantity > 0)
			{
				pnl = (marketPrice - averagePrice) / num * num2 * (double)positionQuantity;
				return true;
			}
			if (positionQuantity < 0)
			{
				pnl = (averagePrice - marketPrice) / num * num2 * (double)(-(double)positionQuantity);
				return true;
			}
			pnl = double.MinValue;
			return false;
		}

		public static bool TryCalcPnL(double averagePrice, double marketPrice, int positionQuantity, MarketPosition marketPosition, Instrument instrument, out double pnl)
		{
			if (instrument == null)
			{
				pnl = double.MinValue;
				return false;
			}
			double num = Delegate727.smethod_0(Delegate726.smethod_0(instrument, Delegate726.delegate726_0), Delegate727.delegate727_0);
			double num2 = num * Delegate728.smethod_0(Delegate726.smethod_0(instrument, Delegate726.delegate726_0), Delegate728.delegate728_0);
			if (marketPosition == null)
			{
				pnl = (marketPrice - averagePrice) / num * num2 * (double)positionQuantity;
				return true;
			}
			if (marketPosition == 1)
			{
				pnl = (averagePrice - marketPrice) / num * num2 * (double)positionQuantity;
				return true;
			}
			pnl = double.MinValue;
			return false;
		}

		internal static void smethod_4(object object_0)
		{
			AverageCalculation.smethod_1(object_0);
		}

		internal static void smethod_5(object object_0)
		{
			AverageCalculation.smethod_2(object_0);
		}

		internal static object smethod_6(int int_0)
		{
			return Class10.smethod_17(int_0);
		}

		internal static int smethod_7(object object_0)
		{
			return object_0.Count;
		}

		internal static void smethod_8(object object_0, int int_0, int int_1)
		{
			object_0.RemoveRange(int_0, int_1);
		}

		internal static void smethod_9()
		{
		}

		internal static void smethod_10()
		{
		}

		internal static void smethod_11()
		{
		}

		[CompilerGenerated]
		private static NinjaScript ninjaScript_0;
	}
}
